/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.Application;
import jas2.util.FieldBinding;
import jas2.util.UnsupportedType;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.lang.reflect.Constructor;
import javax.swing.JOptionPane;

class TextFieldBinding
extends FieldBinding
implements TextListener {
    private String m_oldVal = "";
    private TextField m_field;
    private byte m_flags = 0;
    public static final byte MUST_BE_NUMBER = 1;
    public static final byte MUST_BE_INTEGER = 2;
    public static final byte MUST_BE_POSITIVE = 4;

    TextFieldBinding(TextField field, byte flags) {
        this(field);
        this.m_flags = flags;
    }

    TextFieldBinding(TextField field) {
        this.m_field = field;
        field.addTextListener(this);
    }

    @Override
    void set(Object value) {
        String x = value == null ? "" : (value instanceof String ? (String)value : value.toString());
        if (!this.m_oldVal.equals(x)) {
            this.m_field.setText(x);
            this.m_oldVal = x;
        }
    }

    @Override
    Object get(Class type) throws UnsupportedType {
        Object result = null;
        String x = this.m_field.getText();
        if (type.isPrimitive()) {
            if (type == Double.TYPE) {
                return new Double(x);
            }
            if (type == Integer.TYPE) {
                return new Integer(x);
            }
            throw new UnsupportedType(this.m_field, type);
        }
        Class[] strarg = new Class[]{x.getClass()};
        try {
            Constructor c = type.getConstructor(strarg);
            Object[] args = new Object[]{x};
            result = c.newInstance(args);
        }
        catch (Exception xx) {
            throw new UnsupportedType(this.m_field, type);
        }
        return result;
    }

    @Override
    public void textValueChanged(TextEvent e) {
        String x = this.m_field.getText();
        if (!x.equals(this.m_oldVal)) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getText();
    }

    @Override
    boolean hasValidInput() {
        String value = this.m_field.getText();
        if ((this.m_flags & 1) != 0) {
            try {
                double d;
                double d2 = d = (this.m_flags & 2) != 0 ? (double)Integer.parseInt(value) : Double.valueOf(value);
                if ((this.m_flags & 4) != 0 && d <= 0.0) {
                    JOptionPane.showMessageDialog(Application.getApplication().getFrame(), value.concat(" is invalid input; value must be positive."), "Error", 0);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(Application.getApplication().getFrame(), value + " is invalid input; value must be a" + ((this.m_flags & 2) != 0 ? "n integer." : " number."), "Error", 0);
                return false;
            }
        }
        return true;
    }
}

