/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.DoubleWithError;
import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class ScientificFormat
extends Format {
    private int sigDigit = 5;
    private int maxWidth = 8;
    private boolean SciNote = false;
    private static final double k = 1.0 / Math.log(10.0);

    public ScientificFormat() {
    }

    public ScientificFormat(int sigDigit, int maxWidth, boolean SciNote) {
        this.setSigDigits(sigDigit);
        this.setMaxWidth(maxWidth);
        this.setScientificNotationStyle(SciNote);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            String result = this.format(((Number)obj).doubleValue());
            return toAppendTo.append(result);
        }
        if (obj instanceof DoubleWithError) {
            DoubleWithError dwe = (DoubleWithError)obj;
            toAppendTo.append(this.format(dwe.getValue()));
            toAppendTo.append("\u00b1");
            int errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getError());
            toAppendTo.append(this.formatError(errorSigDigit, dwe.getError()));
            return toAppendTo;
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public int getSigDigits() {
        return this.sigDigit;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean getScientificNotationStyle() {
        return this.SciNote;
    }

    public void setSigDigits(int SigDigit) {
        if (SigDigit < 1) {
            throw new IllegalArgumentException("sigDigit");
        }
        this.sigDigit = SigDigit;
    }

    public void setMaxWidth(int mWidth) {
        if (mWidth < 3) {
            throw new IllegalArgumentException("maxWidth");
        }
        this.maxWidth = mWidth;
    }

    public void setScientificNotationStyle(boolean sciNote) {
        this.SciNote = sciNote;
    }

    private double Log10(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return Math.log(x) * k;
    }

    private int resolveErrorSigDigit(double x, double dx) {
        dx = Math.abs(dx);
        x = Math.abs(x);
        if (dx == 0.0 || Double.isInfinite(dx) || Double.isNaN(dx) || dx >= x) {
            return this.sigDigit;
        }
        if (x == 0.0 || Double.isInfinite(x) || Double.isNaN(x)) {
            return this.sigDigit;
        }
        int log = (int)Math.round(this.Log10(dx / x));
        int errorsigdigit = this.sigDigit + log;
        if (errorsigdigit < 1) {
            return 1;
        }
        return errorsigdigit;
    }

    public String format(double d) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        String result = "";
        double c = 0.0;
        int ShiftNumber = 0;
        int IntOfNumberinput = 0;
        if (d == 0.0) {
            return "0";
        }
        c = d;
        IntOfNumberinput = (int)Math.floor(this.Log10(d = Math.abs(c)));
        if (IntOfNumberinput > -1 && d % Math.pow(10.0, IntOfNumberinput + 1) == 0.0) {
            ++IntOfNumberinput;
        }
        ShiftNumber = this.Log10(d) < 0.0 ? this.sigDigit - IntOfNumberinput - 1 : this.sigDigit - IntOfNumberinput;
        long temp = Math.round(Math.pow(10.0, ShiftNumber) * d);
        String Formatted = String.valueOf(temp);
        BigDecimal tempbunk = new BigDecimal(Math.pow(10.0, ShiftNumber) * d);
        long bunk = tempbunk.longValue();
        String Formattedbunk = String.valueOf(bunk);
        if (Formatted.length() > Formattedbunk.length()) {
            ++IntOfNumberinput;
        }
        if (!this.SciNote) {
            if (IntOfNumberinput < 0) {
                String LoopZero1 = "";
                for (int a = 0; a < Math.abs(IntOfNumberinput) - 1; ++a) {
                    LoopZero1 = LoopZero1 + "0";
                }
                result = "0." + LoopZero1 + Formatted;
            } else {
                int a;
                String[] FillDigits = new String[IntOfNumberinput + 1];
                for (a = 0; a <= IntOfNumberinput; ++a) {
                    FillDigits[a] = "0";
                }
                for (a = 0; a < Formatted.length() && a <= IntOfNumberinput; ++a) {
                    FillDigits[a] = Formatted.substring(a, a + 1);
                }
                for (int i = 0; i <= FillDigits.length - 1; ++i) {
                    result = result + FillDigits[i];
                }
                int length = result.length();
                if (length < this.sigDigit) {
                    String resultaddon = "";
                    int i = -1;
                    if (IntOfNumberinput == 0) {
                        while (length < this.sigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i + 1, result.length() + i + 2);
                            ++length;
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (length < this.sigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i, result.length() + i + 1);
                            ++length;
                            ++i;
                        }
                    }
                    result = result + "." + resultaddon;
                }
            }
            if (result.length() > this.maxWidth) {
                result = Formatted.substring(0, 1) + "." + Formatted.substring(1, this.sigDigit) + "E" + IntOfNumberinput;
            }
        }
        if (this.SciNote) {
            result = Formatted.substring(0, 1) + "." + Formatted.substring(1, this.sigDigit) + "E" + IntOfNumberinput;
        }
        if (c > 0.0) {
            return result;
        }
        return "-" + result;
    }

    public String formatError(int eSD, double d) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        int errorSigDigit = eSD;
        String result = "";
        double c = 0.0;
        int ShiftNumber = 0;
        int IntOfNumberinput = 0;
        if (d == 0.0) {
            return "0";
        }
        c = d;
        IntOfNumberinput = (int)Math.floor(this.Log10(d = Math.abs(c)));
        if (IntOfNumberinput > -1 && d % Math.pow(10.0, IntOfNumberinput + 1) == 0.0) {
            ++IntOfNumberinput;
        }
        ShiftNumber = this.Log10(d) < 0.0 ? errorSigDigit - IntOfNumberinput - 1 : errorSigDigit - IntOfNumberinput;
        long temp = Math.round(Math.pow(10.0, ShiftNumber) * d);
        String Formatted = String.valueOf(temp);
        BigDecimal tempbunk = new BigDecimal(Math.pow(10.0, ShiftNumber) * d);
        long bunk = tempbunk.longValue();
        String Formattedbunk = String.valueOf(bunk);
        if (Formatted.length() > Formattedbunk.length()) {
            ++IntOfNumberinput;
        }
        if (!this.SciNote) {
            if (IntOfNumberinput < 0) {
                String LoopZero1 = "";
                for (int a = 0; a < Math.abs(IntOfNumberinput) - 1; ++a) {
                    LoopZero1 = LoopZero1 + "0";
                }
                result = "0." + LoopZero1 + Formatted;
            } else {
                int a;
                String[] FillDigits = new String[IntOfNumberinput + 1];
                for (a = 0; a <= IntOfNumberinput; ++a) {
                    FillDigits[a] = "0";
                }
                for (a = 0; a < Formatted.length() && a <= IntOfNumberinput; ++a) {
                    FillDigits[a] = Formatted.substring(a, a + 1);
                }
                for (int i = 0; i <= FillDigits.length - 1; ++i) {
                    result = result + FillDigits[i];
                }
                int length = result.length();
                if (length < errorSigDigit) {
                    String resultaddon = "";
                    int i = -1;
                    if (IntOfNumberinput == 0) {
                        while (length < errorSigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i + 1, result.length() + i + 2);
                            ++length;
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (length < errorSigDigit) {
                            resultaddon = resultaddon + Formatted.substring(result.length() + i, result.length() + i + 1);
                            ++length;
                            ++i;
                        }
                    }
                    result = result + "." + resultaddon;
                }
            }
            if (result.length() > this.maxWidth) {
                result = Formatted.substring(0, 1) + "." + Formatted.substring(1, errorSigDigit) + "E" + IntOfNumberinput;
            }
        }
        if (this.SciNote) {
            result = Formatted.substring(0, 1) + "." + Formatted.substring(1, errorSigDigit) + "E" + IntOfNumberinput;
        }
        if (c > 0.0) {
            return result;
        }
        return "-" + result;
    }
}

