/*
 * Decompiled with CFR 0.152.
 */
package jas2.util;

import jas2.util.ImageException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class JASIcon
extends ImageIcon {
    private Class m_c;
    private String m_file;
    private static Hashtable imageCache = new Hashtable();
    private static JASIcon brokenIcon;
    private static Image noImage;

    JASIcon(String file) throws ImageException {
        this((Class)null, file);
    }

    public JASIcon(Object obj, String file) throws ImageException {
        this(obj == null ? null : obj.getClass(), file);
    }

    public JASIcon(Class c, String file) throws ImageException {
        this.m_c = c == null ? JASIcon.class : c;
        this.setImageImpl(file);
    }

    public JASIcon(Class c) {
        this.m_c = c == null ? JASIcon.class : c;
    }

    public void setImage(String file) {
        try {
            this.setImageImpl(file);
        }
        catch (ImageException x) {
            this.setImage(brokenIcon.getImage());
        }
    }

    private void setImageImpl(String file) throws ImageException {
        this.m_file = file;
        Image image = (Image)imageCache.get(this);
        if (image == null) {
            try {
                URL url = this.m_c.getResource(file);
                if (url != null) {
                    image = Toolkit.getDefaultToolkit().getImage(url);
                } else {
                    byte[] data = this.getImageBytes(this.m_c, this.m_file);
                    if (data == null) {
                        throw new ImageException();
                    }
                    image = Toolkit.getDefaultToolkit().createImage(data);
                }
                imageCache.put(this, image);
            }
            catch (ImageException x) {
                imageCache.put(this, noImage);
                throw x;
            }
        } else if (image == noImage) {
            throw new ImageException();
        }
        this.setImage(image);
    }

    private byte[] getImageBytes(Class c, String file) throws ImageException {
        try {
            InputStream stream = c.getResourceAsStream(file);
            if (stream == null) {
                return null;
            }
            byte[] result = new byte[Math.min(10000, stream.available())];
            int size = 0;
            while (true) {
                if (size == result.length) {
                    throw new ImageException("Image too big for buffer");
                }
                int rc = stream.read(result, result.length - size, size);
                if (rc <= 0) break;
                size += rc;
            }
            stream.close();
            return result;
        }
        catch (IOException x) {
            return null;
        }
    }

    public int hashCode() {
        return this.m_file.hashCode() + this.m_c.hashCode();
    }

    public boolean equals(Object in) {
        if (!(in instanceof JASIcon)) {
            return false;
        }
        JASIcon icon = (JASIcon)in;
        if (icon.m_c != this.m_c) {
            return false;
        }
        return icon.m_file.equals(this.m_file);
    }

    public static JASIcon create(Object obj, String file) {
        try {
            return new JASIcon(obj, file);
        }
        catch (ImageException x) {
            return brokenIcon;
        }
    }

    public static JASIcon create(Class c, String file) {
        try {
            return new JASIcon(c, file);
        }
        catch (ImageException x) {
            return brokenIcon;
        }
    }

    static {
        try {
            brokenIcon = new JASIcon("brokenIcon.gif");
            noImage = brokenIcon.getImage();
        }
        catch (ImageException x) {
            System.err.println("Could not load brokenIcon .. this looks bad!");
        }
    }
}

