/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import hepjas.analysis.Histogram;
import hepjas.analysis.Job;
import hepjas.analysis.ScatterPlot;
import jas2.hep.PartitionAdapter;
import jas2.hist.JASHist;
import jas2.tuple.Cut;
import jas2.tuple.CutList;
import jas2.tuple.CutModel;
import jas2.tuple.CutPanel;
import jas2.tuple.Hist1DModel;
import jas2.tuple.Hist2DModel;
import jas2.tuple.ProfileModel;
import jas2.tuple.ScatterModel;
import jas2.tuple.TupleColumn;
import jas2.tuple.TupleModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

class TuplePanel
extends Box {
    private Job m_job;
    private JASHist m_plot;
    private JComboBox chooser;
    private CutModel cutModel;

    TuplePanel(final TupleColumn[] columns, Job job, JASHist plot) {
        super(1);
        Object[] types = new TupleModel[]{new Hist1DModel(columns), new Hist2DModel(columns), new ProfileModel(columns), new ScatterModel(columns)};
        this.m_job = job;
        this.m_plot = plot;
        JPanel top = new JPanel();
        final JTable table = new JTable();
        this.chooser = new JComboBox(types){

            @Override
            protected void fireActionEvent() {
                TupleModel model = (TupleModel)this.getSelectedItem();
                table.setModel(model);
                model.setRenderers(table.getColumnModel());
                table.sizeColumnsToFit(-1);
            }
        };
        table.setRowHeight(this.chooser.getPreferredSize().height);
        this.chooser.setSelectedIndex(0);
        top.add(new JLabel("Plot type"));
        top.add(this.chooser);
        this.add(top);
        this.add(new JScrollPane(table));
        this.cutModel = new CutModel();
        final JTable cutTable = new JTable(this.cutModel);
        this.add(new JScrollPane(cutTable));
        cutTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = cutTable.getSelectedRow();
                    JDialog dlg = new JDialog();
                    dlg.setContentPane(new CutPanel(CutList.getCutAt(row), TuplePanel.this));
                    dlg.setTitle("Cut Properties");
                    dlg.pack();
                    dlg.show();
                }
            }
        });
        JPanel buttonPanel = new JPanel();
        JButton addCut = new JButton("Add Cut...");
        JButton go = new JButton("Go");
        buttonPanel.add(addCut);
        buttonPanel.add(go);
        this.add(buttonPanel);
        addCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CutList list = CutList.instance();
                JPanel p1 = new JPanel();
                p1.add(new JLabel("Name"));
                JTextField name = new JTextField("Cut " + list.size(), 20);
                p1.add(name);
                JPanel p2 = new JPanel();
                p2.add(new JLabel("Column"));
                JComboBox<TupleColumn> variable = new JComboBox<TupleColumn>(columns);
                p2.add(variable);
                JPanel p3 = new JPanel();
                p3.add(new JLabel("Cut Type"));
                JComboBox<String> type = new JComboBox<String>(Cut.getTypes());
                p3.add(type);
                Object[] options = new Object[]{"Ok", "Cancel"};
                Object[] message = new Object[]{p1, p2, p3};
                int rc = JOptionPane.showOptionDialog(TuplePanel.this, message, "Add Cut", 1, 3, null, options, "Ok");
                if (rc == 1) {
                    return;
                }
                list.addElement(new Cut(name.getText(), (TupleColumn)variable.getSelectedItem(), type.getSelectedIndex()));
            }
        });
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Histogram hist = null;
                ScatterPlot scat = null;
                TuplePanel.this.m_job.removeAllEventAnalyzers();
                TuplePanel.this.m_job.rewind();
                TupleModel m = (TupleModel)TuplePanel.this.chooser.getSelectedItem();
                if (m instanceof Hist1DModel) {
                    TuplePanel.this.m_job.addEventAnalyzer(((Hist1DModel)m).getEventAnalyzer(TuplePanel.this.cutModel));
                    hist = ((Hist1DModel)m).getHistogram();
                    hist.clear();
                } else if (m instanceof ScatterModel) {
                    scat = ((ScatterModel)m).getScatterPlot();
                    scat.clear();
                    TuplePanel.this.m_job.addEventAnalyzer(((ScatterModel)m).getEventAnalyzer(TuplePanel.this.cutModel));
                }
                TuplePanel.this.m_job.go();
                TuplePanel.this.m_plot.removeAllData();
                TuplePanel.this.m_plot.addData(PartitionAdapter.create(hist.getPartition(), hist.getName()));
            }
        });
    }

    void go() {
        ScatterPlot scat;
        Histogram hist;
        TupleModel m = (TupleModel)this.chooser.getSelectedItem();
        if (m instanceof Hist1DModel) {
            hist = ((Hist1DModel)m).getHistogram();
            hist.clear();
        } else if (m instanceof ScatterModel) {
            scat = ((ScatterModel)m).getScatterPlot();
            scat.clear();
        }
        this.m_job.rewind();
        this.m_job.go();
        if (m instanceof Hist1DModel) {
            hist = ((Hist1DModel)m).getHistogram();
            hist.getPartition().done();
        } else if (m instanceof ScatterModel) {
            scat = ((ScatterModel)m).getScatterPlot();
            scat.getPartition().done();
        }
    }
}

