/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import hepjas.analysis.EventAnalyzer;
import hepjas.analysis.EventData;
import hepjas.analysis.Histogram;
import hepjas.analysis.NTupleEventData;
import hepjas.analysis.partition.Abstract1DPartition;
import hepjas.analysis.partition.SimpleDatePartition;
import hepjas.analysis.partition.SimpleIntPartition;
import hepjas.analysis.partition.SimplePartition;
import hepjas.analysis.partition.StringPartition;
import jas2.tuple.CutModel;
import jas2.tuple.TupleColumn;
import jas2.tuple.TupleModel;
import java.util.Date;

class Hist1DModel
extends TupleModel {
    private Histogram m_hist;
    private static String[] rows = new String[]{"X-Axis", "Weight"};
    private static int[] defaults = new int[]{0, -1};

    Histogram getHistogram() {
        return this.m_hist;
    }

    protected Abstract1DPartition getPartition(TupleColumn c) {
        int type = c.getType();
        double min = c.getDataSource().getMin();
        double max = c.getDataSource().getMax();
        if (type == 1) {
            return new SimpleIntPartition((int)min, (int)max);
        }
        if (type == 2) {
            return new SimplePartition(min, max);
        }
        if (type == 3) {
            return new StringPartition();
        }
        if (type == 4) {
            return new SimpleDatePartition(new Date((long)(min * 1000.0)), new Date((long)(max * 1000.0)));
        }
        throw new RuntimeException("Bugcheck");
    }

    EventAnalyzer getEventAnalyzer(CutModel cutModel) {
        this.m_hist = new Histogram("test");
        this.m_hist.setPartition(this.getPartition(this.getColumn(0)));
        return new Analyzer(this.getValue(0), this.getValue(1), this.getColumn(0).getType(), this.m_hist, cutModel);
    }

    protected Hist1DModel(String[] rowLabels, int[] rowValues, TupleColumn[] tupleColumns) {
        super(rows, defaults, tupleColumns);
    }

    Hist1DModel(TupleColumn[] tupleColumns) {
        super(rows, defaults, tupleColumns);
    }

    public String toString() {
        return "1D Histogram";
    }

    class Analyzer
    extends EventAnalyzer {
        private int dataCol;
        private int weightCol;
        private int type;
        private Histogram hist;
        private CutModel cutModel;

        Analyzer(int dataCol, int weightCol, int type, Histogram hist, CutModel model) {
            this.dataCol = dataCol;
            this.weightCol = weightCol;
            this.type = type;
            this.hist = hist;
            this.cutModel = model;
        }

        @Override
        public void processEvent(EventData d) {
            NTupleEventData data = (NTupleEventData)d;
            int rows = this.cutModel.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (!this.cutModel.isEnabled(i) || this.cutModel.getCut(i).apply(data)) continue;
                return;
            }
            if (this.type == 1) {
                if (this.weightCol < 0) {
                    this.hist.fill(data.getInt(this.dataCol));
                } else {
                    this.hist.fillW(data.getInt(this.dataCol), data.getDouble(this.weightCol));
                }
            } else if (this.type == 2) {
                if (this.weightCol < 0) {
                    this.hist.fill(data.getDouble(this.dataCol));
                } else {
                    this.hist.fillW(data.getDouble(this.dataCol), data.getDouble(this.weightCol));
                }
            } else if (this.type == 3) {
                if (this.weightCol < 0) {
                    this.hist.fill(data.getString(this.dataCol));
                } else {
                    this.hist.fillW(data.getString(this.dataCol), data.getDouble(this.weightCol));
                }
            } else if (this.type == 4) {
                if (this.weightCol < 0) {
                    this.hist.fill(data.getDate(this.dataCol));
                } else {
                    this.hist.fillW(data.getDate(this.dataCol), data.getDouble(this.weightCol));
                }
            }
        }
    }
}

