/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import jas2.tuple.Cut;
import jas2.tuple.CutList;
import java.util.BitSet;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;

class CutModel
extends DefaultTableModel
implements ListDataListener {
    private static String[] columns = new String[]{"Cut", "Enabled"};
    private static CutList cutList = CutList.instance();
    private BitSet bits = new BitSet();

    CutModel() {
        cutList.addListDataListener(this);
    }

    public Class getColumnClass(int columnIndex) {
        return columnIndex == 1 ? Boolean.class : String.class;
    }

    @Override
    public int getRowCount() {
        return cutList.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return cutList.elementAt(row);
        }
        return this.bits.get(row) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        System.out.println("value=" + value + " row=" + row + " col=" + column);
        if (column == 1) {
            if (((Boolean)value).booleanValue()) {
                this.bits.set(row);
            } else {
                this.bits.clear(row);
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            this.bits.set(i);
        }
        this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireTableDataChanged();
    }

    boolean isEnabled(int i) {
        return this.bits.get(i);
    }

    Cut getCut(int i) {
        return (Cut)cutList.elementAt(i);
    }
}

