/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.InternalFramesWindowManager;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.WindowManager;
import jas2.util.JASMenuItem;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class WindowMenu
extends JMenu {
    private WindowManager m_winMan;

    private void buildMenu() {
        this.removeAll();
        int n = this.m_winMan.getWindowCount();
        boolean areWindows = n > 0;
        WindowMenuItem temp = new WindowMenuItem("Close", -1);
        this.add(temp);
        temp.setEnabled(areWindows && this.m_winMan.getSelectedWindow() >= 0);
        temp.setMnemonic('C');
        temp = new WindowMenuItem("Close All", -2);
        this.add(temp);
        temp.setEnabled(areWindows);
        temp.setMnemonic('A');
        this.addSeparator();
        this.add(new JASMenuItem("Full Screen", 'F'));
        this.addSeparator();
        boolean showRearrangeOptions = this.m_winMan instanceof InternalFramesWindowManager && areWindows;
        temp = new WindowMenuItem("Cascade", -3);
        this.add(temp);
        temp.setEnabled(showRearrangeOptions);
        temp.setMnemonic('S');
        temp = new WindowMenuItem("Tile Horizontally", -4);
        this.add(temp);
        temp.setEnabled(showRearrangeOptions);
        temp.setMnemonic('H');
        temp = new WindowMenuItem("Tile Vertically", -5);
        this.add(temp);
        temp.setEnabled(showRearrangeOptions);
        temp.setMnemonic('V');
        if (areWindows) {
            this.addSeparator();
            for (int i = 0; i < n; ++i) {
                this.add(new WindowMenuItem(this.m_winMan.getWindowName(i), i));
            }
        }
    }

    @Override
    protected void fireMenuSelected() {
        this.m_winMan = JavaAnalysisStudio.getApp().getWindowManager();
        this.buildMenu();
        super.fireMenuSelected();
    }

    private class WindowMenuItem
    extends JMenuItem {
        private int index;

        WindowMenuItem(String name, int i) {
            super(i >= 0 ? String.valueOf(i + 1) + " " + name : name);
            this.index = i;
            if (i >= 0) {
                this.setMnemonic(48 + (char)(i + 1));
            }
        }

        @Override
        protected void fireActionPerformed(ActionEvent evt) {
            if (this.index == -2) {
                WindowMenu.this.m_winMan.closeAllWindows();
            } else if (this.index == -1) {
                WindowMenu.this.m_winMan.closeWindow(WindowMenu.this.m_winMan.getSelectedWindow());
            } else if (this.index < 0) {
                ((InternalFramesWindowManager)WindowMenu.this.m_winMan).arrange(this.index);
            } else {
                WindowMenu.this.m_winMan.selectWindow(this.index);
            }
        }
    }
}

