/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.NamedObject;
import jas2.hist.DataSource;
import jas2.jds.interfaces.RemotePlotAccess;
import jas2.job.PlotAccess;
import jas2.swingstudio.JASRebinAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

class JASPlotAccessAdaptor
implements PlotAccess {
    private boolean gotConstraints = false;
    private double[] constraints;
    private RemotePlotAccess m_remote;
    private RMIEventDelivery m_ed;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    public JASPlotAccessAdaptor(RemotePlotAccess remote, RMIEventDelivery ed) {
        this.m_remote = remote;
        this.m_ed = ed;
    }

    @Override
    public void delete() {
        try {
            this.m_remote.delete();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public void rename(String newName) throws NamedObject.RenameException {
        try {
            this.m_remote.rename(newName);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public int getNDataSources() {
        try {
            return this.m_remote.getNDataSources();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return 0;
        }
    }

    @Override
    public DataSource getData(int index) {
        try {
            RMIDestination dest = this.m_ed.getRMIDestination();
            return JASRebinAdaptor.getAdaptor(this.m_remote.getData(index, dest), this.m_ed, dest);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return null;
        }
    }

    @Override
    public boolean isConstrained() {
        try {
            if (!this.gotConstraints) {
                this.constraints = this.m_remote.getConstraints();
                this.gotConstraints = true;
            }
            return this.constraints != null;
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return false;
        }
    }

    @Override
    public double getX() {
        return this.constraints[0];
    }

    @Override
    public double getY() {
        return this.constraints[1];
    }

    @Override
    public double getWidth() {
        return this.constraints[2];
    }

    @Override
    public double getHeight() {
        return this.constraints[3];
    }
}

