/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.FitterFactory;
import jas2.hist.FitterRegistry;
import jas2.swingstudio.ClassPathPanel;
import jas2.swingstudio.JASAddRemovePanel;
import jas2.swingstudio.JASClassPath;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASSourcePath;
import jas2.swingstudio.MustTestInput;
import jas2.swingstudio.OptionsDialog;
import jas2.swingstudio.OptionsPage;
import jas2.swingstudio.ProgramPage;
import jas2.swingstudio.ProgramTextArea;
import jas2.swingstudio.SourcePathPanel;
import jas2.util.ColorChooser;
import jas2.util.FontChooserPanel;
import jas2.util.JASEditableComboBox;
import jas2.util.JASTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

final class JASOptionsDialog
extends OptionsDialog {
    JASOptionsDialog(Frame f) {
        super(f, "Options...");
        this.addPage("Defaults", new Defaults());
        this.addPage("Class Path", new ClassPath());
        this.addPage("Source Path", new SourcePath());
        this.addPage("Compiler", new Compiler());
        this.addPage("Timed Backup", new Backup());
        this.addPage("Source Code Text", new Text());
        this.addPage("Source Code Printing", new Printing());
        this.pack();
        this.m_init = true;
        this.show();
    }

    private final class Printing
    extends OptionsPage
    implements MustTestInput {
        private float m_leftValue;
        private float m_rightValue;
        private float m_topValue;
        private float m_bottomValue;
        private JASTextField m_left;
        private JASTextField m_right;
        private JASTextField m_top;
        private JASTextField m_bottom;
        private FontChooserPanel m_printingFontChooser;

        Printing() {
            super(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            JPanel margins = new JPanel(new GridLayout(4, 2));
            margins.add(new JLabel("Top margin:"));
            this.m_top = new JASTextField(String.valueOf(ProgramPage.getTopMargin()));
            margins.add(this.m_top);
            margins.add(new JLabel("Bottom margin:"));
            this.m_bottom = new JASTextField(String.valueOf(ProgramPage.getBottomMargin()));
            margins.add(this.m_bottom);
            margins.add(new JLabel("Left margin:"));
            this.m_left = new JASTextField(String.valueOf(ProgramPage.getLeftMargin()));
            margins.add(this.m_left);
            margins.add(new JLabel("Right margin:"));
            this.m_right = new JASTextField(String.valueOf(ProgramPage.getRightMargin()));
            margins.add(this.m_right);
            this.m_top.addKeyListener(JASOptionsDialog.this);
            this.m_bottom.addKeyListener(JASOptionsDialog.this);
            this.m_left.addKeyListener(JASOptionsDialog.this);
            this.m_right.addKeyListener(JASOptionsDialog.this);
            margins.setBorder(BorderFactory.createTitledBorder("Page margins (in inches)"));
            this.m_printingFontChooser = new FontChooserPanel(ProgramTextArea.getPrintingFont(), ProgramTextArea.getPrintingFontStyle(), ProgramTextArea.getPrintingFontSize());
            this.m_printingFontChooser.addItemListener(JASOptionsDialog.this);
            this.m_printingFontChooser.addChangeListener(JASOptionsDialog.this);
            this.m_printingFontChooser.addKeyListener(JASOptionsDialog.this);
            c.gridx = 0;
            c.gridy = 0;
            c.insets.bottom = 10;
            c.insets.top = 10;
            c.insets.right = 10;
            c.insets.left = 10;
            c.fill = 1;
            this.m_printingFontChooser.setBorder(BorderFactory.createTitledBorder("Printing Font"));
            this.add((Component)this.m_printingFontChooser, c);
            ++c.gridy;
            this.add((Component)margins, c);
        }

        @Override
        String getHelpTopic() {
            return "userInterface.optionsDialog.sourceCodeStyle";
        }

        @Override
        public boolean inputIsValid() {
            try {
                float f;
                float f2;
                float f3;
                float f4;
                String s = this.m_left.getText();
                this.m_leftValue = Float.valueOf(s).floatValue();
                if ((double)f4 < 0.0) {
                    throw new NumberFormatException(s);
                }
                s = this.m_right.getText();
                this.m_rightValue = Float.valueOf(s).floatValue();
                if ((double)f3 < 0.0) {
                    throw new NumberFormatException(s);
                }
                s = this.m_top.getText();
                this.m_topValue = Float.valueOf(s).floatValue();
                if ((double)f2 < 0.0) {
                    throw new NumberFormatException(s);
                }
                s = this.m_bottom.getText();
                this.m_bottomValue = Float.valueOf(s).floatValue();
                if ((double)f < 0.0) {
                    throw new NumberFormatException(s);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid margin value: " + e.getMessage(), "Margin error", 0);
                return false;
            }
            return this.m_printingFontChooser.inputIsValid();
        }

        @Override
        void apply() {
            Font f = this.m_printingFontChooser.getSpecifiedFont();
            ProgramPage.setLeftMargin(this.m_leftValue);
            ProgramPage.setRightMargin(this.m_rightValue);
            ProgramPage.setTopMargin(this.m_topValue);
            ProgramPage.setBottomMargin(this.m_bottomValue);
            ProgramTextArea.setPrintingFont(f.getName());
            ProgramTextArea.setPrintingFontStyle(f.getStyle());
            ProgramTextArea.setPrintingFontSize(f.getSize());
            ProgramPage.updateInstanceFonts();
            ProgramPage.updateInstanceStyles();
        }
    }

    private final class Text
    extends OptionsPage
    implements MustTestInput {
        private float m_tabSizeValue;
        private JCheckBox m_currentLineHighlight;
        private JCheckBox m_bracketHighlight;
        private JCheckBox m_syntaxHighlight;
        private JCheckBox m_blinkingCaret;
        private JCheckBox m_electricBorders;
        private JASTextField m_tabSize;
        private FontChooserPanel m_fontChooser;
        private final ColorChooser m_comment;
        private final ColorChooser m_string;
        private final ColorChooser m_keyword;
        private final ColorChooser m_number;
        private final ColorChooser m_line;
        private final ColorChooser m_bracket;
        private final ColorChooser m_foreground;
        private final ColorChooser m_background;
        private final ColorChooser m_caret;
        private final ColorChooser m_selection;

        Text() {
            super(new GridBagLayout());
            this.m_fontChooser = new FontChooserPanel(ProgramTextArea.getDisplayFont(), ProgramTextArea.getFontStyle(), ProgramTextArea.getFontSize());
            this.m_fontChooser.addItemListener(JASOptionsDialog.this);
            this.m_fontChooser.addChangeListener(JASOptionsDialog.this);
            this.m_fontChooser.addKeyListener(JASOptionsDialog.this);
            JPanel editorOptions = new JPanel(new GridBagLayout());
            GridBagConstraints eo = new GridBagConstraints();
            eo.gridx = 0;
            eo.anchor = 17;
            eo.fill = 0;
            eo.insets.bottom = 0;
            eo.insets.top = 0;
            eo.insets.right = 0;
            eo.insets.left = 0;
            JPanel tabSizePanel = new JPanel(new FlowLayout());
            tabSizePanel.add(new JLabel("Tab Size:"));
            this.m_tabSize = new JASTextField(new Integer(JASOptionsDialog.this.m_app.getUserProperties().getInteger("tabSize", 4)).toString(), 5);
            tabSizePanel.add(this.m_tabSize);
            this.m_tabSize.addKeyListener(JASOptionsDialog.this);
            editorOptions.add((Component)tabSizePanel, eo);
            this.m_currentLineHighlight = new JCheckBox("Current line highlighting", ProgramTextArea.getCurrentLineHighlight());
            editorOptions.add((Component)this.m_currentLineHighlight, eo);
            this.m_bracketHighlight = new JCheckBox("Bracket highlighting", ProgramTextArea.getTheBracketHighlight());
            editorOptions.add((Component)this.m_bracketHighlight, eo);
            this.m_syntaxHighlight = new JCheckBox("Highlight syntax tokens", ProgramTextArea.getSyntaxHighlight());
            editorOptions.add((Component)this.m_syntaxHighlight, eo);
            this.m_blinkingCaret = new JCheckBox("Blinking Caret", ProgramTextArea.getBlinkingCaret());
            editorOptions.add((Component)this.m_blinkingCaret, eo);
            this.m_electricBorders = new JCheckBox("Electric (auto scroll) borders", ProgramTextArea.getTheElectricBorders());
            editorOptions.add((Component)this.m_electricBorders, eo);
            editorOptions.setBorder(BorderFactory.createTitledBorder("Editor Options"));
            this.m_currentLineHighlight.addChangeListener(JASOptionsDialog.this);
            this.m_bracketHighlight.addChangeListener(JASOptionsDialog.this);
            this.m_syntaxHighlight.addChangeListener(JASOptionsDialog.this);
            this.m_blinkingCaret.addChangeListener(JASOptionsDialog.this);
            this.m_electricBorders.addChangeListener(JASOptionsDialog.this);
            JPanel colors = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets.bottom = 5;
            c.insets.top = 5;
            c.insets.right = 5;
            c.insets.left = 5;
            colors.add((Component)new JLabel("String Color"), c);
            colors.add((Component)new JLabel("Keyword Color"), c);
            colors.add((Component)new JLabel("Comment Color"), c);
            colors.add((Component)new JLabel("Number Color"), c);
            c.gridx = 1;
            c.gridy = 0;
            c.insets.bottom = 0;
            c.insets.top = 0;
            c.insets.right = 0;
            c.insets.left = 0;
            this.m_string = new ColorChooser(ProgramTextArea.getStringColor());
            colors.add((Component)this.m_string, c);
            ++c.gridy;
            this.m_keyword = new ColorChooser(ProgramTextArea.getKeywordColor());
            colors.add((Component)this.m_keyword, c);
            ++c.gridy;
            this.m_comment = new ColorChooser(ProgramTextArea.getCommentColor());
            colors.add((Component)this.m_comment, c);
            ++c.gridy;
            this.m_number = new ColorChooser(ProgramTextArea.getNumberColor());
            colors.add((Component)this.m_number, c);
            colors.setBorder(BorderFactory.createTitledBorder("Syntax Colors"));
            JPanel editorColors = new JPanel(new GridBagLayout());
            GridBagConstraints ec = new GridBagConstraints();
            ec.gridx = 0;
            ec.anchor = 17;
            ec.fill = 0;
            ec.insets.bottom = 5;
            ec.insets.top = 5;
            ec.insets.right = 5;
            ec.insets.left = 5;
            editorColors.add((Component)new JLabel("Line Highlight Color"), ec);
            editorColors.add((Component)new JLabel("Bracket Highlight Color"), ec);
            editorColors.add((Component)new JLabel("Foreground Color"), ec);
            editorColors.add((Component)new JLabel("Background Color"), ec);
            editorColors.add((Component)new JLabel("Caret Color"), ec);
            editorColors.add((Component)new JLabel("Selection Color"), ec);
            ec.gridx = 1;
            ec.gridy = 0;
            ec.insets.bottom = 0;
            ec.insets.top = 0;
            ec.insets.right = 0;
            ec.insets.left = 0;
            this.m_line = new ColorChooser(ProgramTextArea.getLineColor());
            editorColors.add((Component)this.m_line, ec);
            ++ec.gridy;
            this.m_bracket = new ColorChooser(ProgramTextArea.getBracketColor());
            editorColors.add((Component)this.m_bracket, ec);
            ++ec.gridy;
            this.m_foreground = new ColorChooser(ProgramTextArea.getForegroundColor());
            editorColors.add((Component)this.m_foreground, ec);
            ++ec.gridy;
            this.m_background = new ColorChooser(ProgramTextArea.getBackgroundColor());
            editorColors.add((Component)this.m_background, ec);
            ++ec.gridy;
            this.m_caret = new ColorChooser(ProgramTextArea.getTheCaretColor());
            editorColors.add((Component)this.m_caret, ec);
            ++ec.gridy;
            this.m_selection = new ColorChooser(ProgramTextArea.getTheSelectionColor());
            editorColors.add((Component)this.m_selection, ec);
            editorColors.setBorder(BorderFactory.createTitledBorder("Editor Colors"));
            this.m_string.addColorListener(JASOptionsDialog.this);
            this.m_keyword.addColorListener(JASOptionsDialog.this);
            this.m_comment.addColorListener(JASOptionsDialog.this);
            this.m_number.addColorListener(JASOptionsDialog.this);
            this.m_line.addColorListener(JASOptionsDialog.this);
            this.m_bracket.addColorListener(JASOptionsDialog.this);
            this.m_foreground.addColorListener(JASOptionsDialog.this);
            this.m_background.addColorListener(JASOptionsDialog.this);
            this.m_caret.addColorListener(JASOptionsDialog.this);
            this.m_selection.addColorListener(JASOptionsDialog.this);
            c.gridx = 0;
            c.gridy = 0;
            c.insets.bottom = 10;
            c.insets.top = 10;
            c.insets.right = 10;
            c.insets.left = 10;
            c.fill = 1;
            this.m_fontChooser.setBorder(BorderFactory.createTitledBorder("Display Font"));
            this.add((Component)this.m_fontChooser, c);
            ++c.gridy;
            this.add((Component)editorOptions, c);
            ++c.gridx;
            c.gridy = 0;
            this.add((Component)colors, c);
            ++c.gridy;
            this.add((Component)editorColors, c);
        }

        @Override
        String getHelpTopic() {
            return "userInterface.optionsDialog.sourceCodeStyle";
        }

        @Override
        public boolean inputIsValid() {
            try {
                float f;
                String s = this.m_tabSize.getText();
                this.m_tabSizeValue = Float.valueOf(s).floatValue();
                if ((double)f < 0.0) {
                    throw new NumberFormatException(s);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid tab size value: " + e.getMessage(), "Tab size error", 0);
                return false;
            }
            return this.m_fontChooser.inputIsValid();
        }

        @Override
        void apply() {
            Font f = this.m_fontChooser.getSpecifiedFont();
            ProgramTextArea.setFontStyle(f.getStyle());
            ProgramTextArea.setFontSize(f.getSize());
            ProgramPage.setTabSize(new Integer(this.m_tabSize.getText().toString()));
            ProgramPage.updateInstanceFonts();
            ProgramTextArea.setKeywordColor(this.m_keyword.getColor());
            ProgramTextArea.setCommentColor(this.m_comment.getColor());
            ProgramTextArea.setStringColor(this.m_string.getColor());
            ProgramTextArea.setNumberColor(this.m_number.getColor());
            ProgramTextArea.setLineColor(this.m_line.getColor());
            ProgramTextArea.setBracketColor(this.m_bracket.getColor());
            ProgramTextArea.setForegroundColor(this.m_foreground.getColor());
            ProgramTextArea.setBackgroundColor(this.m_background.getColor());
            ProgramTextArea.setTheCaretColor(this.m_caret.getColor());
            ProgramTextArea.setTheSelectionColor(this.m_selection.getColor());
            ProgramTextArea.setCurrentLineHighlight(this.m_currentLineHighlight.isSelected());
            ProgramTextArea.setTheBracketHighlight(this.m_bracketHighlight.isSelected());
            ProgramTextArea.setSyntaxHighlight(this.m_syntaxHighlight.isSelected());
            ProgramTextArea.setBlinkingCaret(this.m_blinkingCaret.isSelected());
            ProgramTextArea.setTheElectricBorders(this.m_electricBorders.isSelected());
            ProgramPage.updateInstanceStyles();
        }
    }

    private final class Backup
    extends OptionsPage
    implements MustTestInput {
        private JASTextField m_backupTimeField;
        private JASTextField m_dirField;
        private JCheckBox m_doBackupsBox;
        private int m_backupInterval;

        Backup() {
            super(null);
            this.setLayout(new BoxLayout(this, 1));
            JPanel dirPanel = new JPanel(new FlowLayout(0));
            final JLabel dirLabel = new JLabel("Select the directory for timed backups ");
            dirPanel.add(dirLabel);
            this.m_dirField = new JASTextField(ProgramPage.getBackupDirectory(), 15);
            dirPanel.add(this.m_dirField);
            this.m_dirField.addKeyListener(JASOptionsDialog.this);
            JPanel timingPanel = new JPanel(new FlowLayout(0));
            int delayInMillis = ProgramPage.getBackupInterval();
            float delayInMins = (float)delayInMillis / 60000.0f;
            String delayAsString = String.valueOf(delayInMins);
            this.m_backupTimeField = new JASTextField(delayAsString, 10);
            this.m_backupTimeField.addKeyListener(JASOptionsDialog.this);
            final JLabel timingLabel = new JLabel("Set timing interval in minutes: ");
            timingPanel.add(timingLabel);
            timingPanel.add(this.m_backupTimeField);
            this.m_doBackupsBox = new JCheckBox("Do timed backups of text pages", ProgramPage.timerIsRunning());
            this.m_doBackupsBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JASOptionsDialog.this.setChanged();
                    boolean b = Backup.this.m_doBackupsBox.isSelected();
                    dirLabel.setEnabled(b);
                    dirLabel.repaint();
                    timingLabel.setEnabled(b);
                    timingLabel.repaint();
                    Backup.this.m_backupTimeField.setEnabled(b);
                    Backup.this.m_backupTimeField.repaint();
                    Backup.this.m_dirField.setEnabled(b);
                    Backup.this.m_dirField.repaint();
                }
            });
            if (!this.m_doBackupsBox.isSelected()) {
                dirLabel.setEnabled(false);
                timingLabel.setEnabled(false);
                this.m_backupTimeField.setEnabled(false);
                this.m_dirField.setEnabled(false);
            }
            this.add(this.m_doBackupsBox);
            this.add(timingPanel);
            this.add(dirPanel);
        }

        @Override
        public boolean inputIsValid() {
            if (this.m_doBackupsBox.isSelected()) {
                String dir = this.m_dirField.getText();
                if (!this.isValidDirectory(dir)) {
                    JOptionPane.showMessageDialog(this, dir.concat(" is not a valid directory."), "Directory not found", 0);
                    return false;
                }
                String backup = this.m_backupTimeField.getText();
                try {
                    this.m_backupInterval = (int)(Float.valueOf(backup).floatValue() * 60000.0f);
                    if (this.m_backupInterval <= 0) {
                        JOptionPane.showMessageDialog(this, "Backup time must be positive.", "Negative Backup Time", 0);
                    }
                    return false;
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, backup.concat(" is not a valid number."), "Number Format Exception", 0);
                    return false;
                }
            }
            return true;
        }

        private boolean isValidDirectory(String s) {
            try {
                return new File(s).isDirectory();
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        String getHelpTopic() {
            return "jobs.eventAnalysisAndGeneration.timedBackup";
        }

        @Override
        void apply() {
            boolean doBackups = this.m_doBackupsBox.isSelected();
            if (doBackups) {
                String dir = this.m_dirField.getText();
                ProgramPage.setBackupInterval(this.m_backupInterval);
                ProgramPage.setBackupDirectory(dir);
            }
            ProgramPage.setTimerIsRunning(doBackups);
        }
    }

    private final class Compiler
    extends OptionsPage {
        private JCheckBox m_compilerToggle;
        private JASEditableComboBox m_compilerChoice;

        Compiler() {
            super(new GridBagLayout());
            boolean builtInCompiler = JASOptionsDialog.this.m_app.getUserProperties().getBoolean("UseBuiltInCompiler", true);
            this.m_compilerToggle = new JCheckBox("Use Built-in compiler", builtInCompiler){

                @Override
                protected void fireActionPerformed(ActionEvent ae) {
                    Compiler.this.m_compilerChoice.setEnabled(!Compiler.this.m_compilerToggle.isSelected());
                }
            };
            this.m_compilerToggle.addChangeListener(JASOptionsDialog.this);
            this.m_compilerChoice = new JASEditableComboBox("recentCompilers", 4, true);
            this.m_compilerChoice.setEnabled(!builtInCompiler);
            this.m_compilerChoice.setText(JASOptionsDialog.this.m_app.getUserProperties().getString("Compiler", "javac"));
            this.m_compilerChoice.addChangeListener(JASOptionsDialog.this);
            this.m_compilerChoice.setMinWidth(200);
            this.m_compilerChoice.setMaxWidth(300);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.anchor = 17;
            this.add((Component)this.m_compilerToggle, c);
            this.add((Component)new JLabel("Java Compiler Command:"), c);
            this.add((Component)this.m_compilerChoice, c);
        }

        @Override
        void apply() {
            JASOptionsDialog.this.m_app.getUserProperties().setBoolean("UseBuiltInCompiler", this.m_compilerToggle.isSelected());
            JASOptionsDialog.this.m_app.getUserProperties().setString("Compiler", this.m_compilerChoice.getText());
            this.m_compilerChoice.saveState();
        }

        @Override
        String getHelpTopic() {
            return "jobs.eventAnalysisAndGeneration.compiling";
        }
    }

    private final class Defaults
    extends OptionsPage
    implements MustTestInput {
        private final JCheckBox m_lastJob;
        private final JCheckBox m_fullPathForJobs;
        private final JCheckBox m_fullPathForFiles;
        private final JTextField m_jobsListLength;
        private final JTextField m_fileListLength;
        private final JTextField m_classListLength;
        private FitterFactory m_defaultFitterFactory;
        private boolean m_defaultFitterFactorySet;

        Defaults() {
            super(new GridBagLayout());
            this.m_defaultFitterFactorySet = false;
            this.m_lastJob = new JCheckBox("Open last job at startup", JASOptionsDialog.this.m_app.getUserProperties().getBoolean("OpenLastJobAtStartup", false));
            this.m_lastJob.setMnemonic('l');
            this.m_lastJob.addChangeListener(JASOptionsDialog.this);
            final JButton openNow = new JButton("Open last job now");
            openNow.setMnemonic('w');
            String[] fa = JASOptionsDialog.this.m_app.getLastJobs();
            if (fa != null && fa.length > 0) {
                openNow.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JASOptionsDialog.this.m_app.openLastJob();
                        openNow.setEnabled(false);
                    }
                });
                JASJob job = JASOptionsDialog.this.m_app.getJob();
                openNow.setEnabled(job == null || !fa[0].equals(job.getFilePath()));
            }
            JComboBox fitters = new JComboBox();
            Enumeration e = FitterRegistry.instance().elements();
            while (e.hasMoreElements()) {
                fitters.addItem(e.nextElement());
            }
            fitters.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    FitterFactory newItem = (FitterFactory)ev.getItem();
                    if (newItem != Defaults.this.m_defaultFitterFactory) {
                        Defaults.this.m_defaultFitterFactory = newItem;
                        Defaults.this.m_defaultFitterFactorySet = true;
                        JASOptionsDialog.this.setChanged();
                    }
                }
            });
            this.m_fullPathForJobs = new JCheckBox("Show directory for recent jobs", JASOptionsDialog.this.m_prop.getBoolean("InclPath-Jobs", true));
            this.m_fullPathForJobs.setMnemonic('j');
            this.m_fullPathForJobs.addChangeListener(JASOptionsDialog.this);
            this.m_fullPathForFiles = new JCheckBox("Show directory in recent files", JASOptionsDialog.this.m_prop.getBoolean("InclPath-Files", true));
            this.m_fullPathForFiles.setMnemonic('f');
            this.m_fullPathForFiles.addChangeListener(JASOptionsDialog.this);
            this.m_jobsListLength = new JTextField(JASOptionsDialog.this.m_prop.getString("MaxJobsListLength", "4"), 5);
            this.m_jobsListLength.addKeyListener(JASOptionsDialog.this);
            this.m_fileListLength = new JTextField(JASOptionsDialog.this.m_prop.getString("MaxFileListLength", "4"), 5);
            this.m_fileListLength.addKeyListener(JASOptionsDialog.this);
            this.m_classListLength = new JTextField(JASOptionsDialog.this.m_prop.getString("MaxClassesLength", "4"), 5);
            this.m_classListLength.addKeyListener(JASOptionsDialog.this);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            this.add((Component)this.m_lastJob, c);
            c.gridx = 1;
            this.add((Component)openNow, c);
            c.gridx = 0;
            c.gridy = 1;
            this.add((Component)new JLabel("Default fitter: "), c);
            c.gridx = 1;
            this.add(fitters, c);
            c.gridx = 0;
            c.gridy = 2;
            this.add((Component)this.m_fullPathForJobs, c);
            c.gridx = 1;
            this.add((Component)new JLabel("Length of recent jobs list: "), c);
            c.gridx = 2;
            this.add((Component)this.m_jobsListLength, c);
            c.gridx = 0;
            c.gridy = 3;
            this.add((Component)this.m_fullPathForFiles, c);
            c.gridx = 1;
            this.add((Component)new JLabel("Length of recent file list: "), c);
            c.gridx = 2;
            this.add((Component)this.m_fileListLength, c);
            c.gridx = 1;
            c.gridy = 4;
            this.add((Component)new JLabel("Length of recent class list: "), c);
            c.gridx = 2;
            this.add((Component)this.m_classListLength, c);
            this.setBorder(BorderFactory.createTitledBorder("Miscellaneous defaults"));
        }

        @Override
        public boolean inputIsValid() {
            try {
                if (Integer.parseInt(this.m_jobsListLength.getText()) < 0 || Integer.parseInt(this.m_classListLength.getText()) < 0 || Integer.parseInt(this.m_fileListLength.getText()) < 0) {
                    JASOptionsDialog.this.m_app.error("Cannot have negative list length.");
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                JASOptionsDialog.this.m_app.error("Could not format number: ".concat(e.getMessage()));
                return false;
            }
        }

        @Override
        void apply() {
            JASOptionsDialog.this.m_app.getUserProperties().setBoolean("OpenLastJobAtStartup", this.m_lastJob.isSelected());
            if (this.m_defaultFitterFactorySet) {
                FitterRegistry.instance().setDefaultFitterFactory(this.m_defaultFitterFactory);
            }
            JASOptionsDialog.this.m_prop.setBoolean("InclPath-Files", this.m_fullPathForFiles.isSelected());
            JASOptionsDialog.this.m_prop.setBoolean("InclPath-Jobs", this.m_fullPathForJobs.isSelected());
            JASOptionsDialog.this.m_prop.setString("MaxJobsListLength", this.m_jobsListLength.getText());
            JASOptionsDialog.this.m_prop.setString("MaxFileListLength", this.m_fileListLength.getText());
            JASOptionsDialog.this.m_prop.setString("MaxClassesLength", this.m_classListLength.getText());
        }

        @Override
        String getHelpTopic() {
            return "userInterface.optionsDialog.defaultsTab";
        }
    }

    private final class SourcePath
    extends OptionsPage {
        private JASSourcePath path;
        private boolean enable;
        private JASAddRemovePanel panel;

        SourcePath() {
            super(new BorderLayout());
            this.path = JASSourcePath.create();
            this.enable = this.path.isEnabled();
            final JCheckBox disable = new JCheckBox("Use Class Path as Source Path", !this.enable);
            this.add((Component)disable, "North");
            disable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SourcePath.this.enable = !disable.isSelected();
                    SourcePath.this.panel.setEnabled(SourcePath.this.enable);
                    JASOptionsDialog.this.setChanged();
                }
            });
            this.panel = new SourcePathPanel(this.path);
            this.panel.addListDataListener(JASOptionsDialog.this);
            this.panel.setEnabled(this.path.isEnabled());
            this.add((Component)this.panel, "Center");
        }

        @Override
        void apply() {
            this.path.setEnabled(this.enable);
            if (this.enable) {
                this.panel.update();
            }
        }

        @Override
        String getHelpTopic() {
            return "userInterface.optionsDialog.sourcePath";
        }
    }

    private final class ClassPath
    extends OptionsPage {
        private JASAddRemovePanel panel;

        ClassPath() {
            super(new BorderLayout());
            this.panel = new ClassPathPanel(JASClassPath.create());
            this.panel.addListDataListener(JASOptionsDialog.this);
            this.add("Center", this.panel);
        }

        @Override
        void apply() {
            this.panel.update();
        }

        @Override
        String getHelpTopic() {
            return "functionsAndFilters.registries";
        }
    }
}

