/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASPageContext;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Application;
import jas2.util.ColorConverter;
import jas2.util.JASIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ObjectView;

class JASObjectView
extends ObjectView {
    private JASPageContext context;

    JASObjectView(Element elem, JASPageContext context) {
        super(elem);
        this.context = context;
    }

    @Override
    protected Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        String classname = (String)attr.getAttribute(HTML.Attribute.CLASSID);
        String name = (String)attr.getAttribute(HTML.Attribute.ID);
        try {
            Class c = this.getClass(classname);
            Object o = c.newInstance();
            if (o instanceof Component) {
                Component comp = (Component)o;
                this.setParameters(comp, attr);
                this.context.addBean(name, o);
                return comp;
            }
            throw new RuntimeException("Class " + classname + " is not a Component");
        }
        catch (Throwable e) {
            return this.getUnloadableRepresentation(e);
        }
    }

    Component getUnloadableRepresentation(final Throwable t) {
        JButton bomb = new JButton("Error...", JASIcon.create(this, "images/Bomb.gif")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                Application.getApplication().error("Error loading object", t);
            }
        };
        bomb.setToolTipText("Click on Bomb to see error");
        return bomb;
    }

    private Class getClass(String className) throws ClassNotFoundException {
        Class<?> docClass = this.getDocument().getClass();
        ClassLoader loader = docClass.getClassLoader();
        try {
            if (loader != null) {
                return loader.loadClass(className);
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException x) {
            JASJob jj = JavaAnalysisStudio.getApp().getJob();
            if (jj == null) {
                throw x;
            }
            return jj.loadClientClass(className);
        }
    }

    private void setParameters(Component comp, AttributeSet attr) {
        BeanInfo bi;
        Class<?> k = comp.getClass();
        try {
            bi = Introspector.getBeanInfo(k);
        }
        catch (IntrospectionException ex) {
            System.err.println("introspector failed, ex: " + ex);
            return;
        }
        PropertyDescriptor[] props = bi.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            Object v = attr.getAttribute(props[i].getName());
            if (!(v instanceof String)) continue;
            String value = (String)v;
            Method writer = props[i].getWriteMethod();
            if (writer == null) {
                return;
            }
            try {
                Object[] args = new Object[]{this.convert(value, props[i].getPropertyType())};
                writer.invoke((Object)comp, args);
                continue;
            }
            catch (Throwable ex) {
                System.err.println("Invocation failed: " + ex);
            }
        }
    }

    private Object convert(String value, Class type) {
        if (type == String.class) {
            return value;
        }
        if (type == Color.class) {
            try {
                return ColorConverter.stringToHTMLColor(value);
            }
            catch (ColorConverter.ColorConversionException x) {
                throw new RuntimeException(x.getMessage());
            }
        }
        if (type.isPrimitive()) {
            if (type == Double.TYPE) {
                type = Double.class;
            } else if (type == Boolean.TYPE) {
                type = Boolean.class;
            } else if (type == Integer.TYPE) {
                type = Integer.class;
            } else if (type == Float.TYPE) {
                type = Float.class;
            } else if (type == Byte.TYPE) {
                type = Byte.class;
            } else if (type == Character.TYPE) {
                type = Character.class;
            } else if (type == Long.TYPE) {
                type = Long.class;
            } else if (type == Short.TYPE) {
                type = Short.class;
            } else if (type == Void.TYPE) {
                type = Void.class;
            }
        }
        Class[] argsClass = new Class[]{value.getClass()};
        Object[] args = new Object[]{value};
        try {
            Method m = type.getMethod("valueOf", argsClass);
            Object result = type.newInstance();
            m.invoke(result, args);
            return result;
        }
        catch (Throwable m) {
            try {
                Constructor c = type.getConstructor(argsClass);
                Object result = c.newInstance(args);
                return result;
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Could not convert " + value + " to " + type);
            }
        }
    }
}

