/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.EventData;
import jas2.jds.interfaces.ConnectionRejected;
import jas2.jds.interfaces.JavaDataServer;
import jas2.jds.interfaces.PluginEvent;
import jas2.jds.interfaces.RemoteCut;
import jas2.jds.interfaces.RemoteEventSourceFolder;
import jas2.jds.interfaces.RemoteEventUpdate;
import jas2.jds.interfaces.RemoteHistogramAccess;
import jas2.jds.interfaces.RemoteJob;
import jas2.jds.interfaces.RemoteJobInfo;
import jas2.jds.interfaces.RemoteJobUpdate;
import jas2.jds.interfaces.RemotePageAccess;
import jas2.jds.interfaces.RemotePlotAccess;
import jas2.jds.interfaces.RemotePrintBuffer;
import jas2.jds.interfaces.SecureJavaDataServer;
import jas2.jds.interfaces.Version;
import jas2.jds.module.ModuleException;
import jas2.jds.security.PasswordHandler;
import jas2.jds.security.PasswordRequiredException;
import jas2.job.AnalysisException;
import jas2.job.LoaderException;
import jas2.job.NoSuchItemError;
import jas2.job.OpenJobException;
import jas2.plugin.RunEvent;
import jas2.plugin.RunListener;
import jas2.swingstudio.ConnectFailed;
import jas2.swingstudio.JASClassLoader;
import jas2.swingstudio.JASCutAdaptor;
import jas2.swingstudio.JASEventSourceFolderAdaptor;
import jas2.swingstudio.JASHistogramAccessAdaptor;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JASPageAccessAdaptor;
import jas2.swingstudio.JASPlotAccessAdaptor;
import jas2.swingstudio.JASRebinAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.Job;
import jas2.util.JASWizardPage;
import jas2.util.NestedRuntimeException;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import jas2.util.rmi.RMIEventDeliveryEvent;
import jas2.util.rmi.RMIEventDeliveryListener;
import jas2.util.tree.TreeItem;
import java.awt.Component;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

final class JASJobAdaptor
implements Observer,
Serializable,
Job,
RMIEventDeliveryListener {
    static final long serialVersionUID = 2237223357910298193L;
    private transient int m_port = 0;
    private transient String m_service = null;
    private transient boolean m_treeChanged;
    private transient RMIEventDelivery m_ed;
    private transient int m_maxEvents = 0;
    private transient RemoteJob m_remote;
    private transient RemoteJobInfo m_info;
    private transient BoundedRangeModel m_progress;
    private transient int m_changes = 0;
    private transient URL m_loaderURL;
    private transient Component m_parent;
    private String m_jobName;
    private transient JASJob m_jasJob;
    private transient Vector m_runListeners = new Vector();
    private String m_serverName;
    private Vector m_openDataSets = new Vector();
    private Vector m_loaded = new Vector();
    private transient JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private static boolean RMIInit = false;
    private static final boolean debugLoader = System.getProperty("debugLoader") != null;

    JASJobAdaptor(JASJob jasJob, String jobName, String dataSource, String service, int port, Component dialogParent) {
        this.m_parent = dialogParent;
        this.m_port = port;
        this.m_service = service;
        this.m_jasJob = jasJob;
        this.m_jobName = jobName;
        this.m_serverName = dataSource;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
    }

    JASJobAdaptor(JASJob jasJob, String jobName, JavaDataServer jds, Component dialogParent) throws ModuleException, RemoteException {
        this.m_parent = dialogParent;
        this.m_jasJob = jasJob;
        this.m_jobName = jobName;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
        this.m_ed = new RMIEventDelivery(true);
        this.m_ed.addRMIEventDeliveryListener(this);
        RMIDestination d = this.m_ed.getRMIDestination();
        d.addObserver(this);
        this.m_remote = jds.connectToJob(jobName, this.m_ed, d, new JASClassLoader());
    }

    private URL remoteCodebase() throws MalformedURLException, RemoteException {
        String codebase;
        if (this.m_loaderURL == null && (codebase = this.m_remote.getRemoteCodeBase()) != null) {
            this.m_loaderURL = new URL(codebase);
        }
        return this.m_loaderURL;
    }

    @Override
    public Class loadClientClass(String className) throws ClassNotFoundException {
        try {
            return this.m_app.getExtensionLoader().loadClass(className);
        }
        catch (ClassNotFoundException x) {
            return this.loadRemoteClass(className);
        }
    }

    @Override
    public boolean open() throws ModuleException {
        try {
            JavaDataServer remote = JASJobAdaptor.connectToServer(this.m_serverName, this.m_service, this.m_port, this.m_parent);
            if (remote == null) {
                return false;
            }
            this.m_ed = new RMIEventDelivery(true);
            this.m_ed.addRMIEventDeliveryListener(this);
            RMIDestination d = this.m_ed.getRMIDestination();
            d.addObserver(this);
            this.m_remote = remote.newJob(this.m_jobName, this.m_ed, d, new JASClassLoader());
            return true;
        }
        catch (Exception e) {
            throw new ModuleException("Error opening remote job", e);
        }
    }

    @Override
    public void reopen(ObjectInputStream stream, JASJob jasJob) throws OpenJobException {
        this.m_jasJob = jasJob;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app = JavaAnalysisStudio.getApp();
        this.m_app.setModel(this.m_progress);
        try {
            boolean atEnd;
            int pos;
            this.open();
            Enumeration e = this.m_openDataSets.elements();
            while (e.hasMoreElements()) {
                this.m_remote.openDataSource((TreeItem)e.nextElement());
            }
            e = this.m_loaded.elements();
            while (e.hasMoreElements()) {
                this.m_remote.loadRemoteObject((String)e.nextElement());
            }
            try {
                pos = stream.readInt();
                atEnd = stream.readBoolean();
            }
            catch (EOFException x) {
                pos = 0;
                atEnd = false;
            }
            if (atEnd) {
                this.m_remote.go();
            } else if (pos > 0) {
                this.m_remote.go(pos);
            }
        }
        catch (Exception e) {
            throw new OpenJobException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.m_remote.setPersistent(false);
            this.m_remote.close();
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
        this.m_remote = null;
    }

    void disconnect() {
        try {
            this.m_remote.setPersistent(true);
            this.m_remote.close();
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
        this.m_remote = null;
    }

    @Override
    public void receiveMessage(Object message) {
        try {
            this.m_remote.receiveMessage(null, null, message);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        this.m_changes = 0;
    }

    @Override
    public void closeDataset(TreeItem item) {
        try {
            this.m_remote.closeDataset(item);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    @Override
    public void setEventSource(TreeItem item) {
        try {
            this.m_remote.setEventSource(item);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    @Override
    public Class getEventDataClass(TreeItem item) {
        try {
            String name = this.m_remote.getEventDataClass(item);
            return this.loadClientClass(name);
        }
        catch (ClassNotFoundException name) {
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
        return EventData.class;
    }

    Class loadRemoteClass(String name) throws ClassNotFoundException {
        try {
            URL codebase = this.remoteCodebase();
            if (codebase != null) {
                Class<?> result = RMIClassLoader.loadClass(codebase, name);
                if (debugLoader) {
                    System.out.println("RemoteLoader: loaded " + name + " using codebase " + codebase);
                }
                return result;
            }
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
        catch (MalformedURLException e) {
            this.m_app.error("Remote exception", e);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public EventData getEvent() {
        try {
            return this.m_remote.getEvent();
        }
        catch (RemoteException e) {
            throw new NestedRuntimeException("Error getting event", e);
        }
    }

    @Override
    public void stop() {
        try {
            this.m_remote.stop();
        }
        catch (RemoteException e) {
            this.m_app.error("Could not stop job", e);
        }
    }

    @Override
    public void reload() {
        try {
            this.m_remote.unloadAll();
            Enumeration e = this.m_loaded.elements();
            while (e.hasMoreElements()) {
                this.m_remote.loadRemoteObject((String)e.nextElement());
            }
        }
        catch (Exception e) {
            this.m_app.error("Could not reload job", e);
        }
    }

    @Override
    public boolean isChanged() {
        return this.m_changes > 0;
    }

    public TreeItem[] listItems() {
        try {
            return this.m_remote.listItems();
        }
        catch (RemoteException e) {
            this.m_app.error("Could not list remote items", e);
            return null;
        }
    }

    @Override
    public Object getItem(TreeItem item) {
        try {
            RMIDestination dest = this.m_ed.getRMIDestination();
            RemoteObject r = this.m_remote.getItem(item, dest);
            if (r == null) {
                return null;
            }
            if (r instanceof RemoteEventSourceFolder) {
                return new JASEventSourceFolderAdaptor((RemoteEventSourceFolder)((Object)r));
            }
            if (r instanceof RemoteCut) {
                return new JASCutAdaptor((RemoteCut)((Object)r), this.m_ed);
            }
            if (r instanceof RemotePageAccess) {
                return new JASPageAccessAdaptor((RemotePageAccess)((Object)r), this.m_ed);
            }
            if (r instanceof RemotePlotAccess) {
                return new JASPlotAccessAdaptor((RemotePlotAccess)((Object)r), this.m_ed);
            }
            if (r instanceof RemoteHistogramAccess) {
                return new JASHistogramAccessAdaptor((RemoteHistogramAccess)((Object)r), this.m_ed);
            }
            return JASRebinAdaptor.getAdaptor(r, this.m_ed, dest);
        }
        catch (RemoteException e) {
            if (e.detail instanceof NoSuchItemError) {
                throw (NoSuchItemError)e.detail;
            }
            System.err.println("Error from remote getItem " + e);
            Thread.dumpStack();
            return null;
        }
    }

    @Override
    public boolean isRunnable() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_runnable;
    }

    @Override
    public boolean isRunning() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_running;
    }

    @Override
    public boolean isAtEndOfData() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_atEndOfData;
    }

    @Override
    public boolean isAtStartOfData() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_atStartOfData;
    }

    @Override
    public boolean isPersistent() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_persistent;
    }

    @Override
    public int eventsAnalyzed() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_eventsAnalyzed;
    }

    @Override
    public int eventsTotal() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_eventsTotal;
    }

    @Override
    public String getName() {
        if (this.m_info == null) {
            this.setInfo();
        }
        return this.m_info.m_name;
    }

    @Override
    public void kill() {
        try {
            this.m_remote.kill();
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    @Override
    public void go(int i) {
        try {
            this.m_remote.go(i);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    @Override
    public void rewind() {
        try {
            this.m_remote.restart();
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    @Override
    public void unloadAll() {
        try {
            this.m_remote.unloadAll();
            this.m_loaded.removeAllElements();
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    public TreeItem[] listDataSources() {
        try {
            return this.m_remote.listDataSources();
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
            return null;
        }
    }

    public TreeItem[] getSubItems(TreeItem item) {
        try {
            return this.m_remote.getSubItems(item);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
            return null;
        }
    }

    public void openDataSource(TreeItem name) throws OpenJobException {
        try {
            this.m_remote.openDataSource(name);
            this.m_openDataSets.addElement(name);
        }
        catch (RemoteException e) {
            throw new OpenJobException(e);
        }
    }

    @Override
    public void loadObject(String name) {
        try {
            this.m_remote.loadRemoteObject(name);
            this.m_loaded.addElement(name);
        }
        catch (LoaderException e) {
            this.m_app.error("Could not load", e);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote Exception", e);
        }
    }

    @Override
    public boolean isLoaded(String className) {
        return this.m_loaded.contains(className);
    }

    @Override
    public void setPersistent(boolean persist) {
        try {
            this.m_remote.setPersistent(persist);
        }
        catch (RemoteException e) {
            this.m_app.error("Remote exception", e);
        }
    }

    @Override
    public void eventDelivery(RMIEventDeliveryEvent e) {
        if (e.start()) {
            this.m_treeChanged = false;
        } else if (this.m_treeChanged) {
            this.m_jasJob.updateTree();
        }
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (arg instanceof TreeItem) {
            this.m_treeChanged = true;
            TreeItem item = (TreeItem)arg;
            if ((item.flags & 2) != 0) {
                this.m_jasJob.deleteNode(item);
            } else {
                this.m_jasJob.addNode(item);
            }
        } else if (arg instanceof AnalysisException) {
            this.m_app.error("Error running remote analysis (see Error Message window for details)");
        } else if (arg instanceof String) {
            this.m_app.setMessage((String)arg);
        } else if (arg instanceof RemotePrintBuffer) {
            try {
                RemotePrintBuffer buffer = (RemotePrintBuffer)arg;
                this.m_app.getOutputStream(buffer.getTitle()).write(buffer.getBuffer());
            }
            catch (IOException buffer) {}
        } else if (arg instanceof RemoteJobUpdate) {
            this.update((RemoteJobUpdate)arg);
        } else if (arg instanceof RemoteEventUpdate) {
            this.update(((RemoteEventUpdate)arg).getEvents());
        } else if (arg instanceof PluginEvent) {
            try {
                String name = ((PluginEvent)arg).getName();
                this.m_jasJob.loadPlugin(name);
            }
            catch (Exception e) {
                this.m_app.error("Error loading plugin", e);
            }
        }
    }

    JASWizardPage getCustomWizardPage() {
        return null;
    }

    @Override
    public void addRunListener(RunListener listener) {
        this.m_runListeners.addElement(listener);
    }

    @Override
    public void removeRunListener(RunListener listener) {
        this.m_runListeners.removeElement(listener);
    }

    private void fireRunListeners(RunEvent event) {
        Enumeration e = this.m_runListeners.elements();
        while (e.hasMoreElements()) {
            ((RunListener)e.nextElement()).runStateChanged(event);
        }
    }

    private void update(RemoteJobUpdate update) {
        this.m_info = update.getInfo();
        this.m_jasJob.setCommandChanged();
        this.m_maxEvents = this.m_info.m_eventsTotal > 0 ? this.m_info.m_eventsTotal : 100;
        this.m_progress.setMaximum(this.m_maxEvents);
        this.m_progress.setValue(this.m_info.m_eventsAnalyzed);
        if (!this.m_runListeners.isEmpty()) {
            this.fireRunListeners(new RunEvent(this, this.m_info.m_running ? 3000 : 2999));
        }
    }

    private void update(int events) {
        if (this.m_info != null) {
            this.m_info.m_eventsAnalyzed = events;
        }
        if (this.m_info.m_eventsAnalyzed > this.m_maxEvents) {
            this.m_maxEvents *= 3;
            this.m_progress.setMaximum(this.m_maxEvents);
        }
        this.m_progress.setValue(this.m_info.m_eventsAnalyzed);
    }

    private void setInfo() {
        try {
            this.m_info = this.m_remote.getJobInfo();
        }
        catch (RemoteException e) {
            System.out.println(e);
        }
    }

    static JavaDataServer connectToServer(String serverName, String serviceName, int port, Component parent) throws ConnectFailed {
        if (serviceName == null) {
            serviceName = Version.getService();
        }
        String url = "//" + serverName + (port == 0 ? "" : ":" + port) + "/" + serviceName;
        JavaDataServer remote = null;
        try {
            PasswordHandler ph = null;
            try {
                remote = (JavaDataServer)Naming.lookup(url);
                boolean jobsExist = remote.openConnection(System.getProperty("user.name"), Version.getVersion());
                return remote;
            }
            catch (PasswordRequiredException ep1) {
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("clientUser", System.getProperty("user.name"));
                ph = ep1.getPasswordHandler();
                while (true) {
                    try {
                        Object x = ph.getPasswordInfo(parent, ht);
                        if (x == null) {
                            return null;
                        }
                        boolean jobsExist = ((SecureJavaDataServer)remote).openSecureConnection((String)ht.get("clientUser"), Version.getVersion(), x);
                        return remote;
                    }
                    catch (PasswordRequiredException ep2) {
                        ph = ep2.getPasswordHandler();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (ConnectionRejected e) {
            double got = e.getGot();
            double expected = e.getExpected();
            if (got == expected) {
                throw new ConnectFailed("Connection Rejected ", e);
            }
            throw new ConnectFailed("Server incompatible (got " + got + " expected " + expected + ")", e);
        }
        catch (ConnectException e) {
            throw new ConnectFailed("Java Data Server not running on host " + serverName, e);
        }
        catch (UnknownHostException e) {
            throw new ConnectFailed("Unknown host " + serverName, e);
        }
        catch (NotBoundException e) {
            throw new ConnectFailed("Java Data Server not running on host " + serverName, e);
        }
        catch (MalformedURLException e) {
            throw new ConnectFailed("Bad host, port or service name " + serverName, e);
        }
        catch (RemoteException e) {
            throw new ConnectFailed("Unexpected exception during connect to " + serverName, e);
        }
    }
}

