/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASConsoleDocumentUtilities;
import jas2.swingstudio.JASConsoleScrollPane;
import jas2.swingstudio.JASConsoleTabbedPane;
import java.io.IOException;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class JASConsoleDocumentWriter
extends Writer {
    private String theScrollPaneName;
    private Document theDocument;
    private AttributeSet theAttributeSet;
    private JASConsoleTabbedPane theTabbedPane;

    public JASConsoleDocumentWriter(Document doc, AttributeSet a, String s, JASConsoleTabbedPane j) {
        this.theDocument = doc;
        this.theAttributeSet = a;
        this.theScrollPaneName = s;
        this.theTabbedPane = j;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, len));
    }

    @Override
    public void write(String str) throws IOException {
        if (this.theDocument == null) {
            throw new IOException("Writer was closed");
        }
        try {
            int theTabIndex = this.theTabbedPane.indexOfTab(this.theScrollPaneName);
            if (theTabIndex != -1) {
                this.theTabbedPane.setSelectedIndex(theTabIndex);
            } else {
                JASConsoleScrollPane theScrollPane = this.theTabbedPane.getSelectedConsoleScrollPane();
                JASConsoleScrollPane theNewScrollPane = new JASConsoleScrollPane(this.theScrollPaneName, this.theTabbedPane);
                this.theTabbedPane.addTab(this.theScrollPaneName, theNewScrollPane);
                theTabIndex = this.theTabbedPane.indexOfTab(this.theScrollPaneName);
                this.theTabbedPane.setSelectedIndex(theTabIndex);
                theNewScrollPane.getTheTextArea().setDocument(this.theDocument);
                theNewScrollPane.setOutputAttributes(this.theAttributeSet);
            }
            this.theDocument.insertString(this.theDocument.getLength(), str, this.theAttributeSet);
            this.appendToLog(str);
            JASConsoleDocumentUtilities.trimDoc(this.theDocument);
            this.theTabbedPane.getSelectedConsoleScrollPane().scrollToEnd();
        }
        catch (BadLocationException ble) {
            throw new IOException(ble.getMessage());
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.theDocument == null) {
            throw new IOException("Writer was closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.theDocument = null;
    }

    private void appendToLog(String s) {
        JASConsoleScrollPane theScrollPane = this.theTabbedPane.getSelectedConsoleScrollPane();
        if (theScrollPane != null && theScrollPane.getTheTextArea().isLoggingOn()) {
            try {
                theScrollPane.getTheTextArea().getLogWriter().write(s);
                theScrollPane.getTheTextArea().getLogWriter().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

