/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASList;
import jas2.swingstudio.JASListModel;
import jas2.util.JASIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class JASAddRemovePanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private JASListModel model;
    private JList list;
    private String addText;
    private JButton up = new JButton(JASIcon.create(this, "images/up.gif"));
    private JButton down = new JButton(JASIcon.create(this, "images/down.gif"));
    private JButton delete = new JButton(JASIcon.create(this, "images/delete.gif"));
    private JButton add = new JButton(JASIcon.create(this, "images/new2.gif"));

    JASAddRemovePanel(JASList path, String instructions, String borderText, String addText, ListCellRenderer r) {
        this(path, instructions, borderText, addText);
        this.list.setCellRenderer(r);
    }

    JASAddRemovePanel(JASList path, String instructions, String borderText, String addText) {
        super(new BorderLayout());
        if (borderText != null) {
            this.setBorder(BorderFactory.createTitledBorder(borderText));
        }
        this.model = new JASListModel(path);
        this.list = new JList(this.model);
        this.addText = addText;
        Box box = Box.createVerticalBox();
        box.add(this.up);
        box.add(this.down);
        box.add(this.delete);
        box.add(this.add);
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        this.delete.addActionListener(this);
        this.add.addActionListener(this);
        Insets margin = new Insets(0, 0, 0, 0);
        this.up.setMargin(margin);
        this.down.setMargin(margin);
        this.delete.setMargin(margin);
        this.add.setMargin(margin);
        this.up.setToolTipText("Move item up");
        this.down.setToolTipText("Move item down");
        this.delete.setToolTipText("Delete item");
        this.add.setToolTipText("New item");
        this.list.addListSelectionListener(this);
        if (instructions != null) {
            this.add((Component)new JLabel(instructions), "North");
        }
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setPreferredSize(new Dimension(100, 40));
        this.add((Component)scroll, "Center");
        this.add((Component)box, "East");
        this.setSensitive();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int i = this.list.getSelectedIndex();
        if (source == this.up) {
            this.model.swap(i, i - 1);
            this.list.setSelectedIndex(i - 1);
        } else if (source == this.down) {
            this.model.swap(i, i + 1);
            this.list.setSelectedIndex(i + 1);
        } else if (source == this.delete) {
            this.model.delete(i);
        } else if (source == this.add) {
            Object o = this.add(this.addText);
            if (o instanceof Object[]) {
                Object[] oo = (Object[])o;
                for (int j = 0; j < oo.length; ++j) {
                    this.model.add(oo[j]);
                }
            } else if (o != null) {
                this.model.add(o);
            }
        }
        this.setSensitive();
    }

    protected Object add(String addText) {
        return JOptionPane.showInputDialog(this, (Object)addText);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.setSensitive();
    }

    private void setSensitive() {
        boolean enabled = this.isEnabled();
        int i = this.list.getSelectedIndex();
        this.delete.setEnabled(enabled && i >= 0);
        this.up.setEnabled(enabled && i > 0);
        this.down.setEnabled(enabled && i >= 0 && i < this.model.getSize() - 1);
        this.add.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.setSensitive();
    }

    public void update() {
        this.model.update();
    }

    void addListDataListener(ListDataListener l) {
        this.model.addListDataListener(l);
    }

    void setModel(JASList model) {
        this.model = new JASListModel(model);
        this.list.setModel(this.model);
    }
}

