/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.Basic1DFunction;
import jas2.hist.FunctionFactory;
import jas2.hist.FunctionRegistry;
import jas2.swingstudio.JASListOptionModel;
import jas2.util.Application;
import java.util.Vector;
import javax.swing.JOptionPane;

final class FunctionListModel
extends JASListOptionModel {
    private final Application m_app = Application.getApplication();
    private final FunctionRegistry theRegistry;

    FunctionListModel() {
        this(FunctionRegistry.instance());
    }

    FunctionListModel(FunctionRegistry registry) {
        super(registry.elements());
        this.theRegistry = registry;
    }

    @Override
    public Object add() {
        String className = JOptionPane.showInputDialog(Application.getApplication().getFrame(), (Object)"Function or function factory to add to registry");
        if (className == null) {
            return null;
        }
        try {
            FunctionFactory ff;
            Class<?> c = Class.forName(className);
            if (Basic1DFunction.class.isAssignableFrom(c)) {
                String name = JOptionPane.showInputDialog(this.m_app.getFrame(), (Object)"Enter a name for the function");
                if (name == null) {
                    return null;
                }
                ff = this.theRegistry.createFunctionFactory(c, name);
            } else {
                ff = (FunctionFactory)c.newInstance();
            }
            return ff;
        }
        catch (Exception e) {
            this.m_app.error(e instanceof ClassNotFoundException ? "Class not found" : "Function could not be added", e);
            return null;
        }
    }

    @Override
    public void setContents(Vector v) {
        super.setContents(v);
        this.theRegistry.setContents(v);
    }
}

