/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.interfaces.CutInterface;
import jas2.jds.interfaces.CutProperties;
import jas2.swingstudio.CutDialogPanel;
import jas2.swingstudio.CutPropertiesDialog;
import jas2.swingstudio.CutPropertiesPanel;
import jas2.swingstudio.HasPlot;
import jas2.swingstudio.HasSlider;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Application;
import jas2.util.JASDialog;
import jas2.util.JASState;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public abstract class CutAdjustmentDialog
extends JASDialog
implements CutPropertiesDialog {
    private boolean m_changed = false;
    private CutPropertiesPanel m_panel;
    private CutInterface m_peer;
    private CutProperties m_oldProperties;
    final JCheckBox m_showPlot = new JCheckBox("Show plot", false);
    private final String m_auto_Key = "AutoRun";
    private final JCheckBox m_autoRun = new JCheckBox("Run job on change", Application.getApplication().getUserProperties().getBoolean("AutoRun", false));

    public CutAdjustmentDialog(CutInterface peer, CutProperties initialProperties, CutPropertiesPanel panel) {
        super((Frame)Application.getApplication().getFrame(), "Cut parameters", false, 15);
        this.setApplyLabel("Apply and run");
        this.m_oldProperties = initialProperties;
        this.m_peer = peer;
        this.m_panel = panel;
        final Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        panel.m_dialog = this;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        c.add((Component)panel, gbc);
        JPanel boxesPanel = new JPanel(null);
        boxesPanel.setLayout(new BoxLayout(boxesPanel, 1));
        boxesPanel.add(this.m_showPlot);
        JCheckBox showSlider = new JCheckBox("Show slider", false);
        boxesPanel.add(showSlider);
        boxesPanel.add(this.m_autoRun);
        boxesPanel.setBorder(new EtchedBorder());
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        c.add((Component)boxesPanel, gbc);
        boolean hasPlot = initialProperties.m_hasPartition && this instanceof HasPlot;
        boolean hasSlider = this instanceof HasSlider;
        this.m_showPlot.setEnabled(hasPlot);
        showSlider.setEnabled(hasSlider);
        if (this instanceof HasPlot) {
            this.m_showPlot.addItemListener(new ItemListener(){
                private CutDialogPanel m_plot;
                private GridBagConstraints m_const;

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Point p = CutAdjustmentDialog.this.getLocation();
                    if (e.getStateChange() == 1) {
                        if (this.m_plot == null) {
                            this.m_plot = ((HasPlot)((Object)CutAdjustmentDialog.this)).getPlotPanel(CutAdjustmentDialog.this.m_peer);
                            this.m_plot.m_width = c.getSize().width;
                            this.m_const = new GridBagConstraints();
                            this.m_const.gridx = 0;
                            this.m_const.gridy = 0;
                            this.m_const.gridwidth = 2;
                            this.m_const.fill = 1;
                        }
                        if (!this.m_plot.beforeShowing()) {
                            return;
                        }
                        c.add((Component)this.m_plot, this.m_const);
                        CutAdjustmentDialog.this.defaultPack();
                        p.y -= this.m_plot.getSize().height;
                        if (p.y < 0) {
                            p.y = 0;
                        }
                    } else if (e.getStateChange() == 2) {
                        c.remove(this.m_plot);
                        CutAdjustmentDialog.this.defaultPack();
                        p.y += this.m_plot.getSize().height;
                        this.m_plot.afterClosing();
                    }
                    CutAdjustmentDialog.this.setLocation(p);
                }
            });
        }
        if (hasSlider) {
            showSlider.addItemListener(new ItemListener(){
                private CutDialogPanel m_slider;
                private GridBagConstraints m_const;

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (this.m_slider == null) {
                            this.m_slider = ((HasSlider)((Object)CutAdjustmentDialog.this)).getSliderPanel(CutAdjustmentDialog.this.m_peer);
                            this.m_slider.m_width = c.getSize().width;
                            this.m_const = new GridBagConstraints();
                            this.m_const.gridx = 0;
                            this.m_const.gridy = 2;
                            this.m_const.gridwidth = 2;
                            this.m_const.fill = 1;
                        }
                        if (!this.m_slider.beforeShowing()) {
                            return;
                        }
                        c.add((Component)this.m_slider, this.m_const);
                    } else if (e.getStateChange() == 2) {
                        c.remove(this.m_slider);
                        this.m_slider.afterClosing();
                    }
                    CutAdjustmentDialog.this.defaultPack();
                }
            });
        }
        this.setResizable(false);
        this.pack();
    }

    @Override
    public final void changeNotify(boolean reRunJob) {
        if (reRunJob && this.m_autoRun.isSelected()) {
            this.onApply();
        }
        this.m_changed = true;
        this.callEnable();
    }

    @Override
    protected final void onApply() {
        if (this.setProperties()) {
            this.callEnable();
        }
    }

    @Override
    protected final void enableApply(JASState state) {
        JASJob job = JavaAnalysisStudio.getApp().getJob();
        state.setEnabled(this.m_changed && job != null && job.getJob().isRunnable());
    }

    @Override
    protected final void enableOK(JASState state) {
        state.setEnabled(this.m_changed);
    }

    @Override
    protected final void onOK() {
        if (this.setProperties()) {
            Application.getApplication().getUserProperties().setBoolean("AutoRun", this.m_autoRun.isSelected());
            super.onOK();
        }
    }

    protected final CutPropertiesPanel getPropertiesPanel() {
        return this.m_panel;
    }

    private boolean setProperties() {
        CutProperties prop = this.m_panel.getProperties();
        if (prop != null && !prop.equals(this.m_oldProperties)) {
            this.m_oldProperties = prop;
            this.m_changed = false;
            this.m_peer.setProperties(prop);
            this.m_showPlot.setEnabled(prop.m_hasPartition && this instanceof HasPlot);
            return true;
        }
        return false;
    }
}

