/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.ClassPathFileView;
import jas2.swingstudio.ClassPathFilter;
import jas2.swingstudio.ClassPathListCellRenderer;
import jas2.swingstudio.JASAddRemovePanel;
import jas2.swingstudio.UserClassPath;
import jas2.util.Application;
import jas2.util.gui.JDirectoryChooser;
import java.io.File;
import java.util.zip.ZipFile;

class ClassPathPanel
extends JASAddRemovePanel {
    ClassPathPanel(UserClassPath p) {
        super(p, "Look for class files in these directories:", "Class path", null, new ClassPathListCellRenderer());
    }

    @Override
    protected Object add(String addText) {
        Application app = Application.getApplication();
        String dir = app.getUserProperties().getProperty("ClassPathPanel.dir");
        JDirectoryChooser choose = new JDirectoryChooser(dir);
        choose.setFileSelectionMode(2);
        choose.setFileView(new ClassPathFileView());
        choose.setFileFilter(new ClassPathFilter());
        choose.setDialogTitle("Select Directory or Jar File");
        int rc = choose.showDialog(this);
        if (rc != JDirectoryChooser.APPROVE_OPTION) {
            return null;
        }
        File f = choose.getSelectedFile();
        app.getUserProperties().put("ClassPathPanel.dir", f.toString());
        if (f.isDirectory()) {
            return f;
        }
        try {
            return new ZipFile(f);
        }
        catch (Exception x) {
            app.error("Error Opening JAR file", x);
            return null;
        }
    }
}

