/*
 * Decompiled with CFR 0.152.
 */
package jas2.plot;

import jas2.plot.AxisLabel;
import jas2.plot.AxisType;
import jas2.plot.CoordinateTransformation;
import jas2.plot.DateCoordinateTransformation;
import jas2.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public final class DateAxis
extends AxisType
implements DateCoordinateTransformation {
    private TimeZone timeZone = TimeZone.getDefault();
    private final int majorTickLength = 5;
    private final int maxCharsPerLabel = 6;
    private final int minSpaceBetweenLabels = 3;
    private final int minNumberOfDivisions = 1;
    private long data_min = 0L;
    private long data_max = 3600000L;
    private long axis_min = 0L;
    private long axis_max = 3600000L;
    private DateLabel[] labels;
    private final JASCalendar calendar = new JASCalendar();
    private final SimpleDateFormat format = new SimpleDateFormat();
    private final Vector labelVector = new Vector();
    boolean useSuggestedRange = false;
    private final int MILLISECONDS = 0;
    private final int SECONDS = 1;
    private final int MINUTES = 2;
    private final int HOURS = 3;
    private final int DAYS = 4;
    private final int MONTHS = 5;
    private final int YEARS = 6;
    private static final long[] scaleFactors = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 2592000000L, 31104000000L};
    private static final int[] calendarFields = new int[]{14, 13, 12, 11, 5, 2, 1};
    private final String[] normalTimeFormats = new String[]{"s.SSS", "s", "H:mm", "H:mm", "d", "MMM", "yyyy"};
    private final String[] horizontalAxisSecondLineFirstEntryTimeFormats = new String[]{"MMM d, yyyy, H:mm", "MMM d, yyyy, H:mm", "MMM d, yyyy", "MMM d, yyyy", "MMM, yyyy", "yyyy", null};
    private final String[] horizontalAxisSecondLineSubsequentEntryTimeFormats = new String[]{"H:mm", "H:mm", "MMM d", "MMM d", "MMM", "yyyy", null};
    private final String[] verticalAxisFirstEntryTimeFormats = new String[]{"MMM d, yyyy, H:mm:ss.SSS", "MMM d, yyyy, H:mm:ss", "MMM d, yyyy, H:mm", "MMM d, yyyy, H:mm", "MMM d, yyyy", "MMM, yyyy", "yyyy"};
    private final String[] verticalAxisChangedUnitsTimeFormatsPrefix = new String[]{"(H:mm) ", "(H:mm) ", "MMM d, ", "MMM d, ", "MMM ", "(yyyy) ", null};
    private final int[] monthLengths = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    @Override
    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    @Override
    void assumeAxisLength(int axisLength) {
        Font font = this.axis.getFont();
        FontMetrics fm = this.axis.getToolkit().getFontMetrics(font);
        int maxNumberOfDivisions = this.getMaxNumberOfDivisions(fm, axisLength);
        if (!this.labelsValid || this.labels == null || this.labels.length > maxNumberOfDivisions || this.labels.length < maxNumberOfDivisions / 2) {
            this.labels = this.getAxisLabels(maxNumberOfDivisions);
        }
        DateLabel first = this.labels[0];
        DateLabel lastLabel = this.labels[this.labels.length - 1];
        if (this.axis.getAxisOrientation() == 2) {
            this.spaceRequirements.height = fm.getMaxAscent() + fm.getMaxDescent() + 7;
            this.spaceRequirements.width = Math.max(fm.stringWidth(first.text) / 2 - (int)(first.position * (double)axisLength), 0);
            if (first.subtext != null) {
                this.spaceRequirements.height += fm.getHeight();
                this.spaceRequirements.width = Math.max(fm.stringWidth(first.subtext) - (int)(first.position * (double)axisLength), this.spaceRequirements.width);
            }
            int lastLabelWidth = fm.stringWidth(lastLabel.text);
            if (lastLabel.subtext != null) {
                lastLabelWidth = Math.max(fm.stringWidth(lastLabel.subtext), lastLabelWidth);
            }
            this.spaceRequirements.flowPastEnd = Math.max(lastLabelWidth / 2 + (int)(lastLabel.position * (double)axisLength) - axisLength, 0);
        } else {
            int longest = 0;
            for (int i = 0; i < this.labels.length; ++i) {
                longest = Math.max(fm.stringWidth(this.labels[i].text), longest);
            }
            this.spaceRequirements.width = longest + 7;
            this.spaceRequirements.height = Math.max(fm.getAscent() / 2 + fm.getMaxDescent() - (int)(first.position * (double)axisLength), 0);
            this.spaceRequirements.flowPastEnd = Math.max(fm.getMaxAscent() - fm.getAscent() / 2 + (int)(lastLabel.position * (double)axisLength) - axisLength, 0);
        }
    }

    @Override
    void paintAxis(PlotGraphics g, double originX, double originY, double length, Color textColor, Color majorTickColor, Color minorTickColor) {
        FontMetrics fm = g.getFontMetrics();
        if (this.axis.getAxisOrientation() == 2) {
            double y = originY + (double)fm.getMaxAscent() + 7.0;
            for (int i = 0; i < this.labels.length; ++i) {
                String text = this.labels[i].text;
                double x = originX + this.labels[i].position * length;
                g.setColor(textColor);
                g.drawString(text, x - (double)(fm.stringWidth(text) / 2), y);
                String subtext = this.labels[i].subtext;
                if (subtext != null) {
                    g.drawString(subtext, i != 0 ? x - (double)(fm.stringWidth(subtext) / 2) : x - (double)fm.stringWidth(subtext), y + (double)fm.getHeight());
                }
                g.setColor(majorTickColor);
                g.drawLine(x, originY + 5.0, x, originY - 5.0);
            }
        } else {
            double x = this.axis.onLeftSide ? originX - 7.0 : originX + 7.0;
            double lineOffset = fm.getAscent() / 2;
            for (int i = 0; i < this.labels.length; ++i) {
                String text = this.labels[i].text;
                double y = originY - this.labels[i].position * length;
                g.setColor(majorTickColor);
                g.drawLine(originX - 5.0, y, originX + 5.0, y);
                g.setColor(textColor);
                g.drawString(text, this.axis.onLeftSide ? x - (double)fm.stringWidth(text) : x, y + lineOffset);
            }
        }
    }

    @Override
    int getMajorTickMarkLength() {
        return 5;
    }

    @Override
    public double convert(long d) {
        return this.timeToPixel(d);
    }

    @Override
    public long map(double i) {
        int minL = this.axis.getMinLocation();
        int maxL = this.axis.getMaxLocation();
        double d = (i - (double)minL) / (double)(maxL - minL);
        return this.axis_min + (long)(d * (double)(this.axis_max - this.axis_min));
    }

    private int getMaxNumberOfDivisions(FontMetrics fm, int axisLength) {
        return Math.max(1, this.axis.getAxisOrientation() == 2 ? axisLength / (fm.charWidth('5') * 6 + 3) : axisLength / (fm.getMaxAscent() + fm.getMaxDescent() + fm.getHeight() + 3));
    }

    private int getScaleIndex(long minDivisionSpan) {
        long minTime = minDivisionSpan * 2L;
        int scaleIndex = scaleFactors.length;
        while (--scaleIndex > 0 && minTime < scaleFactors[scaleIndex]) {
        }
        return scaleIndex;
    }

    private boolean setToZero(int scaleIndex) {
        boolean allMin = true;
        for (int i = 0; i < scaleIndex; ++i) {
            int field = calendarFields[i];
            int min = this.calendar.getMinimum(field);
            boolean isMin = this.calendar.get(field) == min;
            boolean bl = allMin = allMin && isMin;
            if (isMin) continue;
            this.calendar.set(field, min);
        }
        return allMin;
    }

    private DateLabel[] getAxisLabels(int maxNumberOfDivisions) {
        this.calendar.setTimeInMillis(this.data_min);
        this.calendar.setTimeZone(this.timeZone);
        this.format.setTimeZone(this.timeZone);
        this.axis_min = this.data_min;
        this.axis_max = this.data_max;
        this.labelsValid = true;
        long difference = this.data_max - this.data_min;
        int scaleIndex = this.getScaleIndex(difference / (long)maxNumberOfDivisions);
        int unitsPerDivision = 1;
        if ((int)(difference / scaleFactors[scaleIndex]) > maxNumberOfDivisions) {
            int[] acceptableClumps;
            int naturalNumberInClump = (int)(difference / (long)maxNumberOfDivisions / scaleFactors[scaleIndex]) + 1;
            if (scaleIndex == 4) {
                int[] a;
                acceptableClumps = a = new int[]{2, 5, 10, 15};
            } else if (scaleIndex == 6) {
                if (naturalNumberInClump > 100) {
                    int mult = 1;
                    for (int i = naturalNumberInClump; i > 100; i /= 100) {
                        mult *= 100;
                    }
                    int[] a = new int[]{2 * mult, 5 * mult, 10 * mult, 25 * mult, 50 * mult, 100 * mult};
                    acceptableClumps = a;
                } else {
                    int[] a = new int[]{2, 5, 10, 25, 50, 100};
                    acceptableClumps = a;
                }
            } else if (scaleIndex == 0) {
                int[] a = new int[]{2, 5, 10, 25, 50, 100, 200, 250, 500};
                acceptableClumps = a;
            } else if (scaleIndex == 5) {
                int[] a = new int[]{2, 3, 4, 6};
                acceptableClumps = a;
            } else if (scaleIndex == 3) {
                int[] a = new int[]{2, 3, 4, 6, 12};
                acceptableClumps = a;
            } else {
                int[] a = new int[]{2, 5, 10, 15, 20, 30};
                acceptableClumps = a;
            }
            int i = 0;
            while (i - 1 < acceptableClumps.length && naturalNumberInClump > acceptableClumps[i]) {
                ++i;
            }
            unitsPerDivision = acceptableClumps[i];
        }
        boolean allMinAtMin = this.setToZero(scaleIndex);
        if (this.useSuggestedRange) {
            int fieldValue = this.calendar.get(calendarFields[scaleIndex]);
            int mod = (scaleIndex == 4 && unitsPerDivision == 2 ? fieldValue - 1 : fieldValue) % unitsPerDivision;
            if (scaleIndex == 4 && mod != 0 && fieldValue - mod + unitsPerDivision > this.monthLengths[this.calendar.get(2)]) {
                this.calendar.add(calendarFields[scaleIndex], -mod - unitsPerDivision);
            } else if (mod != 0) {
                if (scaleIndex != 4 || fieldValue > unitsPerDivision) {
                    this.calendar.add(calendarFields[scaleIndex], -mod);
                } else {
                    this.calendar.set(5, 1);
                }
            }
            this.axis_min = this.calendar.getTimeInMillis();
            this.calendar.setTimeInMillis(this.data_max);
            fieldValue = this.calendar.get(calendarFields[scaleIndex]);
            mod = (scaleIndex == 4 && unitsPerDivision == 2 ? fieldValue - 1 : fieldValue) % unitsPerDivision;
            if (!this.setToZero(scaleIndex) || mod != 0) {
                this.calendar.add(calendarFields[scaleIndex], unitsPerDivision - mod);
            }
            this.axis_max = this.calendar.getTimeInMillis();
            this.calendar.setTimeInMillis(this.axis_min);
        } else if (!allMinAtMin) {
            if (scaleIndex == 4 && this.calendar.get(5) % unitsPerDivision != 0 && this.calendar.get(5) + unitsPerDivision >= this.monthLengths[this.calendar.get(2)]) {
                this.calendar.set(5, 1);
                this.calendar.add(2, 1);
            } else if (scaleIndex == 4 && this.calendar.get(5) < unitsPerDivision) {
                this.calendar.set(5, 1);
            } else {
                this.calendar.add(calendarFields[scaleIndex], unitsPerDivision - this.calendar.get(calendarFields[scaleIndex]) % unitsPerDivision);
            }
        }
        String normalLine = this.normalTimeFormats[scaleIndex];
        int lastValueOfNextHigherField = -1;
        boolean isHorizontal = this.axis.getAxisOrientation() == 2;
        boolean first = true;
        do {
            int currentValueOfNextHigherField;
            DateLabel newLabel = new DateLabel();
            this.labelVector.addElement(newLabel);
            this.format.applyPattern(first && !isHorizontal ? this.verticalAxisFirstEntryTimeFormats[scaleIndex] : normalLine);
            newLabel.text = this.format.format(this.calendar.getTime());
            newLabel.position = this.timeToDouble(this.calendar.getTimeInMillis());
            if (first) {
                String pattern;
                first = false;
                if (isHorizontal && (pattern = this.horizontalAxisSecondLineFirstEntryTimeFormats[scaleIndex]) != null) {
                    this.format.applyPattern(pattern);
                    newLabel.subtext = this.format.format(this.calendar.getTime());
                }
                if (scaleIndex + 1 < calendarFields.length) {
                    lastValueOfNextHigherField = this.calendar.get(calendarFields[this.getIndexForNextHighestField(scaleIndex)]);
                }
            } else if (scaleIndex + 1 < calendarFields.length && (currentValueOfNextHigherField = this.calendar.get(calendarFields[this.getIndexForNextHighestField(scaleIndex)])) != lastValueOfNextHigherField) {
                if (isHorizontal) {
                    this.format.applyPattern(this.horizontalAxisSecondLineSubsequentEntryTimeFormats[scaleIndex]);
                    newLabel.subtext = this.format.format(this.calendar.getTime());
                } else {
                    this.format.applyPattern(this.verticalAxisChangedUnitsTimeFormatsPrefix[scaleIndex]);
                    newLabel.text = this.format.format(this.calendar.getTime()).concat(newLabel.text);
                }
                lastValueOfNextHigherField = currentValueOfNextHigherField;
            }
            if (scaleIndex == 4 && unitsPerDivision != 1) {
                int day = this.calendar.get(5);
                int nextLabel = day + unitsPerDivision;
                if (day == 1 && unitsPerDivision != 2) {
                    --nextLabel;
                }
                if (nextLabel + unitsPerDivision / 2 > this.monthLengths[this.calendar.get(2)]) {
                    this.calendar.set(5, 1);
                    this.calendar.add(2, 1);
                    if (this.calendar.getTimeInMillis() <= this.axis_max || nextLabel > this.monthLengths[this.calendar.get(2)]) continue;
                    this.calendar.add(2, -1);
                    this.calendar.set(5, nextLabel);
                    continue;
                }
                this.calendar.set(5, nextLabel);
                continue;
            }
            this.calendar.add(calendarFields[scaleIndex], unitsPerDivision);
        } while (this.calendar.getTimeInMillis() <= this.axis_max);
        Object[] result = new DateLabel[this.labelVector.size()];
        this.labelVector.copyInto(result);
        this.labelVector.removeAllElements();
        return result;
    }

    private int getIndexForNextHighestField(int scaleIndex) {
        switch (scaleIndex) {
            case 0: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return scaleIndex + 1;
    }

    private double timeToPixel(long time) {
        int minL = this.axis.getMinLocation();
        int maxL = this.axis.getMaxLocation();
        return (double)minL + this.timeToDouble(time) * (double)(maxL - minL);
    }

    private double timeToDouble(long time) {
        return (double)(time - this.axis_min) / (double)(this.axis_max - this.axis_min);
    }

    public void setMin(long min) {
        if (this.data_min != min) {
            this.labelsValid = false;
            this.data_min = min;
            this.axis_min = min;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public void setMax(long max) {
        if (this.data_max != max) {
            this.labelsValid = false;
            this.data_max = max;
            this.axis_max = max;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public long getDataMin() {
        return this.data_min;
    }

    public long getDataMax() {
        return this.data_max;
    }

    @Override
    public long getAxisMin() {
        return this.axis_min;
    }

    @Override
    public long getAxisMax() {
        return this.axis_max;
    }

    public void setTimeZone(TimeZone z) {
        if (this.timeZone != z) {
            this.labelsValid = false;
            this.timeZone = z;
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setUseSuggestedRange(boolean useSuggestedRange) {
        if (this.useSuggestedRange != useSuggestedRange) {
            this.labelsValid = false;
            this.useSuggestedRange = useSuggestedRange;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean getUseSuggestedRange() {
        return this.useSuggestedRange;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.useSuggestedRange);
        out.writeObject(this.timeZone);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.useSuggestedRange = in.readBoolean();
        this.timeZone = (TimeZone)in.readObject();
    }

    private static final class JASCalendar
    extends GregorianCalendar {
        private JASCalendar() {
        }

        @Override
        public long getTimeInMillis() {
            return super.getTimeInMillis();
        }

        @Override
        public void setTimeInMillis(long time) {
            super.setTimeInMillis(time);
        }
    }

    private static final class DateLabel
    extends AxisLabel {
        String subtext = null;

        private DateLabel() {
        }
    }
}

