/*
 * Decompiled with CFR 0.152.
 */
package jas2.job;

import hepjas.analysis.Folder;
import hepjas.analysis.Histogram;
import hepjas.analysis.HistogramFolder;
import hepjas.analysis.NamedObject;
import hepjas.analysis.Page;
import hepjas.analysis.PeerSupport;
import hepjas.analysis.Plot;
import hepjas.analysis.peer.FolderPeer;
import hepjas.analysis.peer.Peer;
import jas2.job.AbstractJob;
import jas2.job.JobHistogram;
import jas2.job.JobHistogramFolder;
import jas2.job.JobPage;
import jas2.job.JobPlot;
import jas2.util.tree.SimpleNode;

public class JobFolder
extends SimpleNode
implements FolderPeer {
    private AbstractJob m_job;

    JobFolder(AbstractJob job) {
        super("Root", "folder", 4, null);
        this.m_job = job;
    }

    JobFolder(AbstractJob job, Folder f, JobFolder parent, String type) {
        super(parent, f.getName(), type, 4, f);
        this.m_job = job;
    }

    @Override
    public void addNotify(NamedObject o) {
        SimpleNode peer;
        if (o instanceof HistogramFolder) {
            peer = new JobHistogramFolder(this.m_job, (HistogramFolder)o, this);
        } else if (o instanceof Folder) {
            peer = new JobFolder(this.m_job, (Folder)o, this, "folder");
        } else if (o instanceof Histogram) {
            peer = new JobHistogram((Histogram)o, this);
        } else if (o instanceof Page) {
            peer = new JobPage((Page)o, this);
        } else if (o instanceof Plot) {
            peer = new JobPlot((Plot)o, this);
        } else {
            throw new RuntimeException("Unknown object added to folder");
        }
        PeerSupport.setPeer(o, peer);
    }

    @Override
    public void removeNotify(NamedObject o) {
        Peer peer = PeerSupport.getPeer(o);
        SimpleNode child = this.findChild(o.getName());
        child.destroy();
    }

    @Override
    public void changeNotify(NamedObject o, String oldName) {
        SimpleNode child = this.findChild(oldName);
        this.renameChild(child, o.getName());
    }
}

