/*
 * Decompiled with CFR 0.152.
 */
package jas2.job;

import hepjas.analysis.EventAnalyzer;
import hepjas.analysis.EventData;
import hepjas.analysis.EventGenerator;
import hepjas.analysis.EventSource;
import hepjas.analysis.Job;
import hepjas.analysis.PeerSupport;
import jas2.jds.module.AnnotatedEventSource;
import jas2.job.AnalysisException;
import jas2.job.BasicJob;
import jas2.job.JobFolder;
import jas2.job.LoaderException;
import jas2.job.NoSuchItemError;
import jas2.util.tree.SimpleNode;
import jas2.util.tree.TreeItem;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;

public abstract class AbstractJob
extends Observable
implements BasicJob {
    private transient Job m_hepJob;
    private boolean m_stopEventLoop;
    private ClassLoader m_loader;
    private EventData m_event;
    private boolean m_persistent = false;
    private Thread m_eventLoopThread;
    private String m_name;
    private String m_state;
    private Thread m_active;
    private SimpleNode m_source;
    private EventSourceStatus m_status;
    private Hashtable m_statusMap = new Hashtable();
    private SimpleNode m_dataSets;
    private SimpleNode m_programs;
    private JobFolder m_root;
    private EventAnalyzer[] m_analyzer = new EventAnalyzer[10];
    private int m_nAnalyzers = 0;

    public AbstractJob(String name) {
        this.m_state = "Active";
        this.m_name = name;
    }

    protected void setRoot(JobFolder root) {
        this.m_root = root;
    }

    public AbstractJob() {
    }

    public void setHepAnalysisJob(Job job) {
        this.m_hepJob = job;
    }

    public Job getHepAnalysisJob() {
        return this.m_hepJob;
    }

    public SimpleNode getTreeRoot() {
        return this.m_root;
    }

    public final void setEventSource(EventGenerator gen) {
        if (this.m_programs == null) {
            this.createProgramNode();
        }
        String newName = gen.getClass().getName();
        if (this.m_dataSets != null && this.m_dataSets.findChild(newName) != null) {
            int i = 2;
            while (this.m_dataSets.findChild(newName = gen.getClass().getName() + " (" + i + ")") != null) {
                ++i;
            }
        }
        SimpleNode node = this.m_programs.add(new TreeItem(newName, "generator"), gen);
        this.setCurrentEventSource(node);
        this.notifyInfo();
    }

    public final void setEventSource(EventSource source) {
        SimpleNode newSource;
        String newName;
        if (this.m_dataSets == null) {
            this.createDataSetNode();
        }
        if (this.m_dataSets.findChild(newName = source.getName()) != null) {
            int i = 2;
            while (this.m_dataSets.findChild(newName = source.getName() + " (" + i + ")") != null) {
                ++i;
            }
        }
        TreeItem t = new TreeItem(newName, "dataset", 458752);
        if (source instanceof AnnotatedEventSource) {
            SimpleNode node;
            boolean hasEventSourceFolders = false;
            TreeItem[] items = ((AnnotatedEventSource)source).getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].type.equals("eventSourceFolder")) continue;
                items[i].flags |= 0x20000;
                if (hasEventSourceFolders) continue;
                hasEventSourceFolders = true;
                items[i].flags |= 0x40000;
            }
            if (hasEventSourceFolders) {
                t.flags &= 0xFFF9FFFF;
            }
            newSource = node = this.m_dataSets.add(t, source);
            for (int i = 0; i < items.length; ++i) {
                SimpleNode child = node.add(items[i]);
                if ((items[i].flags & 0x40000) == 0) continue;
                newSource = child;
            }
        } else {
            newSource = this.m_dataSets.add(t, source);
        }
        this.setCurrentEventSource(newSource);
        this.notifyInfo();
    }

    @Override
    public void closeDataset(TreeItem item) {
        SimpleNode node = this.m_root.find(item);
        EventSource es = (EventSource)node.getObject();
        if (this.m_source.isAncestorOf(node)) {
            this.setCurrentEventSource(null);
        }
        this.m_statusMap.remove(node);
        Enumeration e = this.m_statusMap.keys();
        while (e.hasMoreElements()) {
            SimpleNode key = (SimpleNode)e.nextElement();
            if (!key.isAncestorOf(node)) continue;
            this.m_statusMap.remove(key);
        }
        node.destroy();
        es.close();
        this.notifyInfo();
    }

    @Override
    public void setEventSource(TreeItem item) {
        SimpleNode node = this.m_root.find(item);
        this.setCurrentEventSource(node);
        this.notifyInfo();
    }

    @Override
    public final Class getEventDataClass(TreeItem item) {
        try {
            return ((EventSource)this.getItem(item)).getEventDataClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setCurrentEventSource(SimpleNode node) {
        if (this.m_source != null) {
            this.m_source.clearFlags(262144);
        }
        this.m_source = node;
        if (this.m_source != null) {
            this.m_source.setFlags(262144);
            this.m_status = (EventSourceStatus)this.m_statusMap.get(this.m_source);
            if (this.m_status == null) {
                this.m_status = new EventSourceStatus();
                this.m_statusMap.put(this.m_source, this.m_status);
            }
        }
    }

    public final void addEventAnalyzer(EventAnalyzer ana) {
        if (this.m_programs == null) {
            this.createProgramNode();
        }
        this.m_programs.add(new TreeItem(ana.getClass().getName(), "analyzer"), ana);
        if (this.m_nAnalyzers >= this.m_analyzer.length) {
            EventAnalyzer[] temp = new EventAnalyzer[this.m_nAnalyzers * 2];
            System.arraycopy(this.m_analyzer, 0, temp, 0, this.m_nAnalyzers);
            this.m_analyzer = temp;
        }
        this.m_analyzer[this.m_nAnalyzers++] = ana;
        this.notifyInfo();
    }

    public final void removeAllEventAnalyzers() {
        this.m_nAnalyzers = 0;
        this.notifyInfo();
    }

    public final void removeEventAnalyzer(EventAnalyzer ana) {
    }

    @Override
    public void close() {
        this.setCurrentEventSource(null);
        if (this.m_dataSets != null) {
            Enumeration e = this.m_dataSets.elements();
            while (e.hasMoreElements()) {
                EventSource s = (EventSource)e.nextElement();
                s.close();
            }
        }
    }

    @Override
    public void loadObject(String name) throws LoaderException {
        try {
            Class[] noArgc = new Class[]{};
            this.setActiveThread();
            Class<?> x = this.m_loader.loadClass(name);
            this.resetFolders();
            if (EventGenerator.class.isAssignableFrom(x)) {
                Constructor<?> c = x.getConstructor(noArgc);
                this.setEventSource((EventGenerator)c.newInstance(noArgc));
                return;
            }
            if (EventAnalyzer.class.isAssignableFrom(x)) {
                Constructor<?> c = x.getConstructor(noArgc);
                this.addEventAnalyzer((EventAnalyzer)c.newInstance(noArgc));
                return;
            }
            try {
                throw new LoaderException("Class " + name + " must extend EventGenerator or EventAnalyzer");
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                PrintWriter p = new PrintWriter(this.getErrorStream());
                p.println("Error occured during instantiation of " + name);
                t.printStackTrace(p);
                p.flush();
                throw new LoaderException("Error instantiating " + name + " (See Output window for details)", t);
            }
            catch (NoSuchMethodException e) {
                throw new LoaderException("Class " + name + " must be public and have public constructor with zero arguments", e);
            }
            catch (IllegalAccessException e) {
                throw new LoaderException("Class " + name + " must be public and have public constructor with zero arguments", e);
            }
            catch (InstantiationException e) {
                throw new LoaderException("Error creating object of class " + name, e);
            }
            catch (Throwable e) {
                throw new LoaderException("Could not load class " + name, e);
            }
        }
        finally {
            this.setActiveThread(null);
        }
    }

    @Override
    public void unloadAll() {
        this.m_nAnalyzers = 0;
        if (this.m_source != null && this.m_source.getObject() instanceof EventGenerator) {
            EventGenerator gen = (EventGenerator)this.m_source.getObject();
            gen.close();
        }
        if (this.m_programs != null) {
            this.m_programs.destroy();
            this.m_programs = null;
        }
    }

    protected final void setClassLoader(ClassLoader cl) {
        this.m_loader = cl;
    }

    @Override
    public Object getItem(TreeItem search) {
        SimpleNode node = this.m_root.find(search);
        if (node == null) {
            throw new NoSuchItemError("Cannot find node " + search);
        }
        Object result = node.getObject();
        if (result == null) {
            throw new NoSuchItemError("Cannot find object " + search);
        }
        return result;
    }

    protected void setState(String state) {
        this.m_state = state;
    }

    private final void beforeFirstEvent() {
        ((EventSource)this.m_source.getObject()).beforeFirstEvent();
        for (int i = 0; i < this.m_nAnalyzers; ++i) {
            this.resetFolders();
            this.m_analyzer[i].beforeFirstEvent();
        }
    }

    private final void afterLastEvent() {
        ((EventSource)this.m_source.getObject()).afterLastEvent();
        for (int i = 0; i < this.m_nAnalyzers; ++i) {
            this.resetFolders();
            this.m_analyzer[i].afterLastEvent();
        }
    }

    private final void processEvent(EventData data) {
        for (int i = 0; i < this.m_nAnalyzers; ++i) {
            this.resetFolders();
            this.m_analyzer[i].processEvent(data);
        }
    }

    @Override
    public final boolean isRunnable() {
        return this.m_eventLoopThread == null && this.m_source != null;
    }

    @Override
    public final boolean isAtEndOfData() {
        return this.m_status == null ? false : this.m_status.m_atEndOfData;
    }

    @Override
    public final boolean isAtStartOfData() {
        return this.m_status == null ? true : this.m_status.m_atStartOfData;
    }

    @Override
    public final boolean isRunning() {
        return this.m_eventLoopThread != null;
    }

    @Override
    public final boolean isPersistent() {
        return this.m_persistent;
    }

    @Override
    public final void rewind() {
        this.m_hepJob.rewind();
    }

    void doRewind() {
        this.m_status.m_atStartOfData = true;
        this.m_status.m_atEndOfData = false;
        this.m_status.m_eventsAnalyzed = 0;
        this.notifyInfo();
    }

    protected Thread createEventLoopThread(Runnable loop) {
        return new Thread(loop, "EventAnalysisThread");
    }

    @Override
    public final void go(int n) {
        this.m_hepJob.go(n);
    }

    void doGo(int n) {
        EventLoop loop = new EventLoop(n);
        this.m_eventLoopThread = this.createEventLoopThread(loop);
        this.setState("running");
        this.notifyInfo();
        this.m_eventLoopThread.start();
    }

    @Override
    public final void stop() {
        this.m_stopEventLoop = true;
        if (this.m_source.getObject() instanceof SlowEventSource) {
            ((SlowEventSource)this.m_source.getObject()).stop();
        }
        this.notifyInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void kill() {
        AbstractJob abstractJob = this;
        synchronized (abstractJob) {
            if (this.m_eventLoopThread != null) {
                this.m_eventLoopThread.stop();
            }
        }
        this.notifyInfo();
    }

    private final void setActiveThread(Thread t) {
        this.m_active = t;
    }

    public final void setActiveThread() {
        this.m_active = Thread.currentThread();
    }

    protected final Thread getActiveThread() {
        return this.m_active;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public final EventData getEvent() {
        return this.m_event;
    }

    public final String getState() {
        return this.m_state;
    }

    @Override
    public final int eventsTotal() {
        return this.m_source == null ? 0 : ((EventSource)this.m_source.getObject()).getTotalNumberOfEvents();
    }

    @Override
    public final int eventsAnalyzed() {
        return this.m_status == null ? 0 : this.m_status.m_eventsAnalyzed;
    }

    @Override
    public void receiveMessage(Object message) {
    }

    @Override
    public final void setPersistent(boolean persist) {
        this.m_persistent = persist;
    }

    private void createDataSetNode() {
        if (this.m_dataSets == null) {
            this.m_dataSets = this.m_root.add(new TreeItem("Data"));
        }
    }

    private void createProgramNode() {
        if (this.m_programs == null) {
            this.m_programs = this.m_root.add(new TreeItem("Programs"));
        }
    }

    private final void resetFolders() {
        PeerSupport.resetFolders(this.m_hepJob);
    }

    void goEnded() {
        PeerSupport.done(this.m_hepJob);
    }

    public void update(Observable obs, Object arg) {
        if (obs instanceof EventSource) {
            this.notifyInfo();
        }
    }

    protected abstract void notifyInfo();

    protected abstract void notifyInfo(int var1);

    protected abstract OutputStream getErrorStream();

    protected abstract OutputStream getLogStream();

    protected abstract void sendMessage(String var1);

    protected abstract void reportError(AnalysisException var1);

    static /* synthetic */ boolean access$102(AbstractJob x0, boolean x1) {
        x0.m_stopEventLoop = x1;
        return x0.m_stopEventLoop;
    }

    static /* synthetic */ EventSourceStatus access$200(AbstractJob x0) {
        return x0.m_status;
    }

    static /* synthetic */ SimpleNode access$300(AbstractJob x0) {
        return x0.m_source;
    }

    static /* synthetic */ void access$400(AbstractJob x0) {
        x0.beforeFirstEvent();
    }

    static /* synthetic */ void access$500(AbstractJob x0, EventData x1) {
        x0.processEvent(x1);
    }

    static /* synthetic */ boolean access$100(AbstractJob x0) {
        return x0.m_stopEventLoop;
    }

    static /* synthetic */ void access$600(AbstractJob x0) {
        x0.afterLastEvent();
    }

    static /* synthetic */ EventData access$702(AbstractJob x0, EventData x1) {
        x0.m_event = x1;
        return x0.m_event;
    }

    static /* synthetic */ Thread access$802(AbstractJob x0, Thread x1) {
        x0.m_eventLoopThread = x1;
        return x0.m_eventLoopThread;
    }

    private class EventLoop
    implements Runnable {
        private int m_maxEvents;

        EventLoop(int maxEvents) {
            this.m_maxEvents = maxEvents;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class EventSourceStopped
    extends RuntimeException {
    }

    public static interface SlowEventSource {
        public void stop();
    }

    private class EventSourceStatus {
        int m_eventsAnalyzed = 0;
        boolean m_atStartOfData = true;
        boolean m_atEndOfData = false;

        private EventSourceStatus() {
        }
    }
}

