/*
 * Decompiled with CFR 0.152.
 */
package jas2.jds.module;

import hepjas.analysis.EventSource;
import jas2.jds.module.AbstractDIM;
import jas2.jds.module.DIM;
import jas2.jds.module.DIM2;
import jas2.jds.module.ModuleException;
import jas2.jds.module.ServerRegistryException;
import jas2.util.tree.TreeItem;
import java.util.Enumeration;
import java.util.Vector;

public class ServerRegistry {
    static final Vector serverList = new Vector();

    public static void registerServer(AbstractDIM d) {
        serverList.addElement(d);
    }

    public static TreeItem[] listDatasets() {
        TreeItem[] result = new TreeItem[serverList.size()];
        Enumeration e = serverList.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            result[i] = new TreeItem();
            result[i].path = new String[1];
            result[i].path[0] = e.nextElement().toString();
            result[i].flags = 1;
            ++i;
        }
        return result;
    }

    public static TreeItem[] getSubItems(TreeItem item) {
        AbstractDIM dim = ServerRegistry.findDIM(item.path[0]);
        if (dim == null) {
            return null;
        }
        if (dim instanceof DIM) {
            Vector v = ((DIM)dim).getDataSets();
            TreeItem[] result = new TreeItem[v.size()];
            Enumeration e = v.elements();
            int i = 0;
            while (e.hasMoreElements()) {
                result[i] = new TreeItem();
                result[i].path = new String[1];
                result[i].path[0] = e.nextElement().toString();
                result[i].flags = 0;
                ++i;
            }
            return result;
        }
        if (dim instanceof DIM2) {
            TreeItem subItem = new TreeItem();
            subItem.path = new String[item.path.length - 1];
            for (int i = 0; i < subItem.path.length; ++i) {
                subItem.path[i] = item.path[i + 1];
            }
            return ((DIM2)dim).getDataSets(subItem);
        }
        throw new RuntimeException("Unknown DIM instance! " + dim);
    }

    private static AbstractDIM findDIM(String name) {
        Enumeration e = serverList.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Object d = e.nextElement();
            if (d.toString().equals(name)) {
                return (AbstractDIM)d;
            }
            ++i;
        }
        return null;
    }

    public static EventSource open(TreeItem item) {
        AbstractDIM dim = ServerRegistry.findDIM(item.path[0]);
        if (dim == null) {
            throw new ServerRegistryException("Error finding DIM: " + item.path[0]);
        }
        try {
            if (dim instanceof DIM) {
                return dim.openDataSet(item.path[1]);
            }
            if (dim instanceof DIM2) {
                TreeItem subItem = new TreeItem();
                subItem.path = new String[item.path.length - 1];
                for (int i = 0; i < subItem.path.length; ++i) {
                    subItem.path[i] = item.path[i + 1];
                }
                return ((DIM2)dim).openDataSet(subItem);
            }
            throw new RuntimeException("Unknown DIM instance! " + dim);
        }
        catch (ModuleException e) {
            throw new ServerRegistryException("Error opening data set: " + item.path[1], e);
        }
    }
}

