/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist.normalization;

import jas2.hist.DataSource;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.normalization.DataSourceNormalizer;

public class AreaNormalizer
extends DataSourceNormalizer {
    public AreaNormalizer(DataSource data) {
        super(data);
        this.init();
    }

    @Override
    protected double calculateNormalization() {
        if (this.source instanceof Rebinnable1DHistogramData) {
            Rebinnable1DHistogramData data = (Rebinnable1DHistogramData)this.source;
            int nBins = data.getBins();
            double xMin = data.getMin();
            double xMax = data.getMax();
            double[][] bins = data.rebin(nBins, xMin, xMax, false, this.hurry);
            double[] y = bins[0];
            double area = 0.0;
            for (int i = 0; i < y.length; ++i) {
                area += y[i];
            }
            double binWidth = (xMax - xMin) / (double)nBins;
            return (area *= binWidth) > 0.0 ? area : 1.0;
        }
        return 1.0;
    }
}

