/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DataManagerException;
import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.JASHist1DHistogramData;
import jas2.hist.JASHistData;
import jas2.hist.OneDDataManager;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.StatisticsBlock;
import jas2.plot.DataArea;
import jas2.plot.DoubleAxis;
import jas2.plot.Legend;
import jas2.plot.StringAxis;
import java.util.Enumeration;
import java.util.Hashtable;

final class StringDataManager
extends OneDDataManager {
    private StringAxis xAxis = new StringAxis();
    private DoubleAxis yAxis = new DoubleAxis();

    StringDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da, l, stats);
        this.yAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.xm.setFixed(true);
        this.ym[0].setDataManager(this, false, this.yAxis);
    }

    @Override
    JASHistData add(DataSource ds) {
        Rebinnable1DHistogramData d = (Rebinnable1DHistogramData)ds;
        if (d.getAxisType() != 2) {
            throw new DataManagerException("Data incompatible with String axis");
        }
        JASHist1DHistogramData dw = new JASHist1DHistogramData(this, d);
        this.data.addElement(dw);
        return dw;
    }

    @Override
    void destroy() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHistData d = (JASHistData)e.nextElement();
            d.deleteNormalizationObserver();
            d.show(false);
        }
        this.data.removeAllElements();
    }

    @Override
    void XAxisUpdated() {
    }

    @Override
    void computeXAxisRange() {
        if (this.data.isEmpty()) {
            return;
        }
        Hashtable<String, String> labels = new Hashtable<String, String>();
        String[] original = null;
        int n = 0;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist1DHistogramData dw = (JASHist1DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            String[] label = dw.getAxisLabels();
            if (n++ == 0) {
                original = label;
            }
            for (int i = 0; i < label.length; ++i) {
                labels.put(label[i], label[i]);
            }
        }
        if (n == 0) {
            return;
        }
        if (n > 1) {
            String[] result = new String[labels.size()];
            Enumeration e2 = labels.keys();
            int i = 0;
            while (e2.hasMoreElements()) {
                result[i] = (String)e2.nextElement();
                ++i;
            }
            this.xAxis.setLabels(result);
        } else {
            this.xAxis.setLabels(original);
        }
        this.xAxis.getAxis().invalidate();
    }

    @Override
    void computeYAxisRange() {
        if (this.data.isEmpty()) {
            return;
        }
        if (!this.ym[0].getRangeAutomatic()) {
            return;
        }
        double ymin = 0.0;
        double ymax = 0.0;
        boolean first = true;
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHist1DHistogramData dw = (JASHist1DHistogramData)e.nextElement();
            if (!dw.isShowing()) continue;
            if (first) {
                ymin = dw.getYMin();
                ymax = dw.getYMax();
                first = false;
                continue;
            }
            ymin = Math.min(ymin, dw.getYMin());
            ymax = Math.max(ymax, dw.getYMax());
        }
        if (ymax <= ymin) {
            ymax = ymin + 1.0;
        }
        if (this.yAxis.isLogarithmic()) {
            ymin = Math.max(ymin, 1.0);
        }
        double oldYMin = this.yAxis.getPlotMin();
        double oldYMax = this.yAxis.getPlotMax();
        if (ymin < oldYMin || ymax > oldYMax || (ymax - ymin) / (oldYMax - oldYMin) < 0.75) {
            this.yAxis.setMin(ymin);
            this.yAxis.setMax(ymax);
            this.yAxis.getAxis().revalidate();
        }
    }
}

