/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.ExtendedStatistics;
import jas2.hist.JASHistData;
import jas2.hist.Statistics;
import jas2.hist.StatsWindow;
import jas2.plot.TextBlock;
import jas2.util.DoubleWithError;
import jas2.util.ScientificFormat;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.Format;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class StatisticsBlock
extends TextBlock {
    private boolean NothingToShow;
    private Format f;
    private Hashtable formats = new Hashtable();
    private StatsWindow statwin;
    private Vector stats = new Vector();
    private String[] selectedentries;
    private String[] listnames;
    private int showtitles = 3;
    private int splitstringalign = 2;
    private String line;
    private JMenuItem statpropertiesitem;
    private boolean alwaysall = true;
    public static final int SHOWTITLES_ALWAYS = 1;
    public static final int SHOWTITLES_NEVER = 2;
    public static final int SHOWTITLES_AUTOMATIC = 3;
    public static final int LEFTALIGNSPLIT = 1;
    public static final int RIGHTALIGNSPLIT = 2;
    public static final int NOALIGNSPLIT = 3;

    public StatisticsBlock() {
        this(new ScientificFormat());
    }

    public StatisticsBlock(Format g) {
        super("Statistics");
        this.initializeDefaultFormats(g);
        this.setFormat(g);
    }

    @Override
    public int getNLines() {
        this.NothingToShow = false;
        if (this.stats.isEmpty()) {
            return 1;
        }
        int n = 0;
        for (int i = 0; i < this.stats.size(); ++i) {
            JASHistData data = (JASHistData)this.stats.elementAt(i);
            Statistics stat = data.getStatistics();
            if (this.selectedentries != null) {
                n += this.addDisplayLines(this.compareEntries(stat)).length;
                continue;
            }
            n += this.addDisplayLines(stat.getStatisticNames()).length;
        }
        if (n == 0) {
            this.NothingToShow = true;
            n = 1;
            return 1;
        }
        return n;
    }

    @Override
    public String getLine(int j) {
        if (this.stats.isEmpty() || this.NothingToShow) {
            return "No Statistics";
        }
        int n = 0;
        for (int i = 0; i < this.stats.size(); ++i) {
            JASHistData data = (JASHistData)this.stats.elementAt(i);
            Statistics stat = data.getStatistics();
            String[] lines_selectedentries = this.addDisplayLines(this.compareEntries(stat));
            String[] lines_noselected = this.addDisplayLines(stat.getStatisticNames());
            if (this.selectedentries != null) {
                if (j - n < lines_selectedentries.length) {
                    String returnline;
                    this.line = lines_selectedentries[j - n];
                    if (this.line.equals("addplottitle")) {
                        return data.getLegendText();
                    }
                    if (this.line.equals("\n")) {
                        return this.line;
                    }
                    if (stat instanceof ExtendedStatistics) {
                        Format extendf;
                        Object obj = ((ExtendedStatistics)stat).getExtendedStatistic(this.line);
                        if (obj == null) {
                            obj = new Double(stat.getStatistic(this.line));
                        }
                        returnline = (extendf = (Format)this.formats.get(obj.getClass())) != null ? this.line + "\t" + extendf.format(obj) : this.line + "\t" + obj.toString();
                    } else {
                        Double d = new Double(stat.getStatistic(this.line));
                        returnline = this.line + "\t" + this.f.format(d);
                    }
                    return returnline;
                }
                n += lines_selectedentries.length;
                continue;
            }
            if (j - n < lines_noselected.length) {
                String returnline;
                this.line = lines_noselected[j - n];
                if (this.line.equals("addplottitle")) {
                    return data.getLegendText();
                }
                if (this.line.equals("\n")) {
                    return this.line;
                }
                if (stat instanceof ExtendedStatistics) {
                    Format extendf;
                    Object obj = ((ExtendedStatistics)stat).getExtendedStatistic(this.line);
                    if (obj == null) {
                        obj = new Double(stat.getStatistic(this.line));
                    }
                    returnline = (extendf = (Format)this.formats.get(obj.getClass())) != null ? this.line + "\t" + extendf.format(obj) : this.line + "\t" + obj.toString();
                } else {
                    Double d = new Double(stat.getStatistic(this.line));
                    returnline = this.line + "\t" + this.f.format(d);
                }
                return returnline;
            }
            n += lines_noselected.length;
        }
        throw new IllegalArgumentException();
    }

    private String[] addDisplayLines(String[] s) {
        if (this.showtitles == 1 || this.showtitles == 3 && this.stats.size() > 1 && s.length > 0) {
            String[] addline = new String[s.length + 2];
            addline[0] = "\n";
            addline[1] = "addplottitle";
            for (int i = 0; i < s.length; ++i) {
                addline[i + 2] = s[i];
            }
            return addline;
        }
        if (s.length > 0) {
            String[] addline = new String[s.length + 1];
            addline[0] = "\n";
            for (int i = 0; i < s.length; ++i) {
                addline[i + 1] = s[i];
            }
            return addline;
        }
        return s;
    }

    private String[] compareEntries(Statistics stat) {
        Object[] compare = stat.getStatisticNames();
        Vector<String> vcompare = new Vector<String>();
        for (int i = 0; i < compare.length; ++i) {
            if (this.selectedentries == null) continue;
            for (int ii = 0; ii < this.selectedentries.length; ++ii) {
                if (!((String)compare[i]).equals(this.selectedentries[ii])) continue;
                vcompare.addElement(this.selectedentries[ii]);
            }
        }
        compare = new String[vcompare.size()];
        vcompare.copyInto(compare);
        return compare;
    }

    public void setSelectedEntries(String[] s) {
        this.selectedentries = s;
    }

    public String[] getSelectedEntries() {
        return this.selectedentries;
    }

    void set_AllwaysAll_Subset(boolean alwaysall) {
        this.alwaysall = alwaysall;
    }

    boolean get_AllwaysAll_Subset() {
        return this.alwaysall;
    }

    public String[] getStatNames() {
        Vector<String> vlistednames = new Vector<String>();
        this.listnames = null;
        for (int i = 0; i < this.stats.size(); ++i) {
            JASHistData data = (JASHistData)this.stats.elementAt(i);
            Statistics stat = data.getStatistics();
            if (stat != null) {
                this.listnames = stat.getStatisticNames();
            }
            if (this.listnames == null) continue;
            for (int ii = 0; ii < this.listnames.length; ++ii) {
                if (vlistednames.contains(this.listnames[ii])) continue;
                vlistednames.addElement(this.listnames[ii]);
            }
        }
        this.listnames = new String[vlistednames.size()];
        vlistednames.copyInto(this.listnames);
        return this.listnames;
    }

    public void add(JASHistData data) {
        if (data.getStatistics() != null) {
            this.stats.addElement(data);
        }
    }

    public void remove(JASHistData data) {
        this.stats.removeElement(data);
    }

    public void clear() {
        this.stats.removeAllElements();
    }

    public void setFormat(Format g) {
        this.f = g;
        this.updateFormatsInstances(this.f);
        this.revalidate();
        this.repaint();
    }

    public Format getFormat() {
        return this.f;
    }

    public void putFormat(Class c, Format f) {
        this.formats.put(c, f);
    }

    private void updateFormatsInstances(Format f) {
        Enumeration e = this.formats.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (this.formats.get(obj).getClass() != f.getClass()) continue;
            this.putFormat(obj.getClass(), f);
        }
    }

    private void initializeDefaultFormats(Format f) {
        if (f instanceof ScientificFormat) {
            this.putFormat(Double.class, f);
            this.putFormat(DoubleWithError.class, f);
        } else {
            ScientificFormat defaultsciformat = new ScientificFormat();
            this.putFormat(Double.class, defaultsciformat);
            this.putFormat(DoubleWithError.class, defaultsciformat);
        }
    }

    @Override
    public int getSplitStringAlign() {
        return this.splitstringalign;
    }

    public void setSplitStringAlign(int a) {
        if (a >= 4 || a <= 0) {
            throw new IllegalArgumentException("Integer splitstringalign must be set to 1,2 or 3");
        }
        this.splitstringalign = a;
    }

    public void setShowTitles(int settitles) {
        if (settitles >= 4 || settitles <= 0) {
            throw new IllegalArgumentException("Integer showtitles must be set to 1,2 or 3");
        }
        this.showtitles = settitles;
    }

    public int getShowTitles() {
        return this.showtitles;
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        this.statpropertiesitem = new JMenuItem(this.getPrefix() + " Properties..."){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                StatisticsBlock.this.statwin = new StatsWindow(StatisticsBlock.this);
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
                StatisticsBlock.this.statwin.showStatsWindow();
            }
        };
        menu.add(this.statpropertiesitem);
        super.modifyPopupMenu(menu, source);
    }
}

