/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DataSource;
import jas2.hist.normalization.AreaNormalizer;
import jas2.hist.normalization.BinNormalizer;
import jas2.hist.normalization.EntriesNormalizer;
import jas2.hist.normalization.MaxBinNormalizer;
import jas2.hist.normalization.Normalizer;
import jas2.hist.normalization.RelativeNormalizer;
import jas2.hist.normalization.SimpleNormalizer;
import jas2.hist.normalization.StatisticsNormalizer;
import jas2.util.xml.XMLNodeTraverser;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class NormalizationTraverser
extends XMLNodeTraverser {
    private String method;
    private String param;
    private String relativeTo;
    private double multiplier;

    NormalizationTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("method")) {
            this.method = value;
        } else if (name.equals("param")) {
            this.param = value;
        } else if (name.equals("multiplier")) {
            this.multiplier = this.toDouble(value);
        } else if (name.equals("relativeTo")) {
            this.relativeTo = value;
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    Normalizer getNormalizer(DataSource data, Hashtable map) throws XMLNodeTraverser.BadXMLException {
        SimpleNormalizer norm = this.createNormalizer(this.method, this.param, data);
        if (this.relativeTo != null) {
            DataSource ds = (DataSource)map.get(this.relativeTo);
            if (ds == null) {
                throw new XMLNodeTraverser.BadXMLException("Could not find data ref " + this.relativeTo);
            }
            SimpleNormalizer rel = this.createNormalizer(this.method, this.param, ds);
            return new RelativeNormalizer(norm, rel);
        }
        norm.setFactor(1.0 / this.multiplier);
        return norm;
    }

    private SimpleNormalizer createNormalizer(String method, String param, DataSource data) throws XMLNodeTraverser.BadXMLException {
        if (method.equals("CONSTANT")) {
            return new SimpleNormalizer(1.0);
        }
        if (method.equals("MAXBIN")) {
            return new MaxBinNormalizer(data);
        }
        if (method.equals("AREA")) {
            return new AreaNormalizer(data);
        }
        if (method.equals("ENTRIES")) {
            return new EntriesNormalizer(data);
        }
        if (method.equals("BIN")) {
            return new BinNormalizer(data, this.toInt(param));
        }
        if (method.equals("STATISTICS")) {
            return new StatisticsNormalizer(data, param);
        }
        throw new XMLNodeTraverser.BadXMLException("Unrecognized normalization method " + method);
    }
}

