/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.ComponentNodeTraverser;
import jas2.hist.JASHist;
import jas2.hist.XMLPrintWriter;
import jas2.plot.Legend;
import jas2.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class LegendNodeTraverser
extends ComponentNodeTraverser {
    private Node node;
    private Legend legend;
    private JASHist plot;

    LegendNodeTraverser() {
    }

    void traverse(Node node, Legend legend, JASHist plot) throws XMLNodeTraverser.BadXMLException {
        this.plot = plot;
        this.legend = legend;
        this.node = node;
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("legendEntry")) {
            int index = this.toInt(node.getAttribute("index"));
            this.legend.setCurrentTitle(index, node.getAttribute("title"));
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("visible")) {
            this.plot.setShowLegend(this.toVisibility(value));
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    void applyLegendEntries() throws XMLNodeTraverser.BadXMLException {
        if (this.node != null) {
            super.traverse(this.node, this.legend);
        }
    }

    private int toVisibility(String value) throws XMLNodeTraverser.BadXMLException {
        return XMLPrintWriter.convertStringToLegend(value);
    }
}

