/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

public class JASHistUtil {
    public static double roundDown(double x, int order) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x == Double.MIN_VALUE) {
            return x;
        }
        if (x < 0.0) {
            return -1.0 * JASHistUtil.roundUp(Math.abs(x), order);
        }
        if (x == 0.0) {
            return x;
        }
        double mant = Math.floor(Math.log(x) / Math.log(10.0));
        double factor = Math.pow(10.0, (double)order - mant);
        double tmp = Math.floor(x * factor) / factor;
        return tmp;
    }

    public static double roundUp(double x, int order) {
        if (Double.isNaN(x) || Double.isInfinite(x) || x == Double.MAX_VALUE) {
            return x;
        }
        if (x < 0.0) {
            return -1.0 * JASHistUtil.roundDown(Math.abs(x), order);
        }
        if (x == 0.0) {
            return x;
        }
        double mant = Math.floor(Math.log(x) / Math.log(10.0));
        double factor = Math.pow(10.0, (double)order - mant);
        double tmp = Math.ceil(x * factor) / factor;
        return tmp;
    }
}

