/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.util.ColorChooser;
import jas2.util.PropertyBinding;
import jas2.util.PropertyPage;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tablelayout.TableLayout;

final class JASHistPropStyle
extends PropertyPage {
    JASHistPropStyle() {
        this.setLayout(new TableLayout());
        this.setBorder(BorderFactory.createTitledBorder("1D Plot Style"));
        JCheckBox hist = new JCheckBox("Histogram Bars");
        ColorChooser histFillColor = new ColorChooser();
        ColorChooser histOutlineColor = new ColorChooser();
        JCheckBox histFilled = new JCheckBox("Filled");
        JComboBox<String> histStyle = new JComboBox<String>();
        histStyle.addItem("Solid");
        histStyle.addItem("Dotted");
        histStyle.addItem("Dashed");
        histStyle.addItem("DotDashed");
        JSpinner histWidth = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 5.5, 0.5));
        JPanel p = new JPanel();
        p.add(new JLabel("Outline"));
        p.add(histFillColor);
        p.add(new JLabel("Fill"));
        p.add(histFilled);
        p.add(histStyle);
        p.add(histWidth);
        this.add("0 0 w", hist);
        this.add("1 0 Hw", histOutlineColor);
        this.add("2 0 lW", p);
        JCheckBox error = new JCheckBox("Error Bars");
        ColorChooser errorColor = new ColorChooser();
        JComboBox<String> errorStyle = new JComboBox<String>();
        errorStyle.addItem("Solid");
        errorStyle.addItem("Dotted");
        errorStyle.addItem("Dashed");
        errorStyle.addItem("DotDashed");
        JSpinner errorWidth = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 5.5, 0.5));
        p = new JPanel();
        p.add(errorStyle);
        p.add(errorWidth);
        this.add("0 1 w", error);
        this.add("1 1 Hw", errorColor);
        this.add("2 1 lW", p);
        JCheckBox points = new JCheckBox("Data Points");
        ColorChooser pointColor = new ColorChooser();
        JComboBox<String> pointStyle = new JComboBox<String>();
        JSpinner pointSize = new JSpinner(new SpinnerNumberModel(2, 1, 99, 1));
        p = new JPanel();
        p.add(pointStyle);
        p.add(pointSize);
        this.add("0 2 w", points);
        this.add("1 2 Hw", pointColor);
        this.add("2 2 lW", p);
        JCheckBox lines = new JCheckBox("Lines Between Points");
        ColorChooser lineColor = new ColorChooser();
        JComboBox<String> lineStyle = new JComboBox<String>();
        lineStyle.addItem("Solid");
        lineStyle.addItem("Dotted");
        lineStyle.addItem("Dashed");
        lineStyle.addItem("DotDashed");
        JSpinner lineWidth = new JSpinner(new SpinnerNumberModel(2.0, 0.0, 7.5, 0.5));
        p = new JPanel();
        p.add(lineStyle);
        p.add(lineWidth);
        this.add("0 3 w", lines);
        this.add("1 3 Hw", lineColor);
        this.add("2 3 lW", p);
        this.addBinding(new PropertyBinding(pointColor, "DataPointColor"));
        this.addBinding(new PropertyBinding(pointStyle, "DataPointStyle"));
        this.addBinding(new PropertyBinding(pointSize, "DataPointSize"));
        this.addBinding(new PropertyBinding(hist, "ShowHistogramBars"));
        this.addBinding(new PropertyBinding(error, "ShowErrorBars"));
        this.addBinding(new PropertyBinding(points, "ShowDataPoints"));
        this.addBinding(new PropertyBinding(lines, "ShowLinesBetweenPoints"));
        this.addBinding(new PropertyBinding(histFillColor, "HistogramBarColor"));
        this.addBinding(new PropertyBinding(histOutlineColor, "HistogramBarLineColor"));
        this.addBinding(new PropertyBinding(errorColor, "ErrorBarColor"));
        this.addBinding(new PropertyBinding(lineColor, "LineColor"));
        this.addBinding(new PropertyBinding(histFilled, "HistogramFill"));
        this.addBinding(new PropertyBinding(lineStyle, "LinesBetweenPointsStyle"));
        this.addBinding(new PropertyBinding(lineWidth, "LinesBetweenPointsWidth"));
        this.addBinding(new PropertyBinding(histStyle, "HistogramBarLineStyle"));
        this.addBinding(new PropertyBinding(histWidth, "HistogramBarLineWidth"));
        this.addBinding(new PropertyBinding(errorStyle, "ErrorBarStyle"));
        this.addBinding(new PropertyBinding(errorWidth, "ErrorBarWidth"));
        pointStyle.addItem("Dot");
        pointStyle.addItem("Box");
        pointStyle.addItem("Triangle");
        pointStyle.addItem("Diamond");
        pointStyle.addItem("Star");
        pointStyle.addItem("Vert Line");
        pointStyle.addItem("Horiz Line");
        pointStyle.addItem("Cross");
        pointStyle.addItem("Circle");
        pointStyle.addItem("Square");
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d1 = super.getMaximumSize();
        Dimension d2 = super.getPreferredSize();
        d1.height = d2.height;
        return d1;
    }
}

