/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.ComponentNodeTraverser;
import jas2.hist.DataAreaNodeTraverser;
import jas2.hist.JASHist;
import jas2.hist.LegendNodeTraverser;
import jas2.hist.StatsNodeTraverser;
import jas2.hist.TitleNodeTraverser;
import jas2.plot.Title;
import jas2.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class JASHistNodeTraverser
extends ComponentNodeTraverser {
    private static TitleNodeTraverser tt = new TitleNodeTraverser();
    private static StatsNodeTraverser st = new StatsNodeTraverser();
    private static DataAreaNodeTraverser dt = new DataAreaNodeTraverser();
    private static LegendNodeTraverser lt = new LegendNodeTraverser();
    private JASHist plot;

    JASHistNodeTraverser() {
    }

    void traverse(Node node, JASHist plot) throws XMLNodeTraverser.BadXMLException {
        this.plot = plot;
        super.traverse(node, plot);
        lt.applyLegendEntries();
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("title")) {
            Title t = this.plot.getTitleObject();
            if (t == null) {
                t = new Title();
                this.plot.setTitleObject(t);
            }
            tt.traverse((Node)node, t);
        } else if (name.equals("stats")) {
            st.traverse((Node)node, this.plot.getStats());
            this.plot.setShowStatistics(true);
        } else if (name.equals("dataArea")) {
            dt.traverse(node, this.plot.getDataArea(), this.plot);
        } else if (name.equals("legend")) {
            lt.traverse(node, this.plot.getLegend(), this.plot);
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("allowUserInteraction")) {
            this.plot.setAllowUserInteraction(this.toBoolean(value));
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }
}

