/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.BinnedDataManager;
import jas2.hist.DataManagerException;
import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.StatisticsBlock;
import jas2.hist.XYDataSource;
import jas2.plot.DataArea;
import jas2.plot.DoubleAxis;
import jas2.plot.Legend;

final class IntegerDataManager
extends BinnedDataManager {
    private DoubleAxis xAxis = new DoubleAxis();
    private int targetBins;

    IntegerDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats, int bins) {
        super(plot, da, l, stats, bins);
        DoubleAxis yAxis = new DoubleAxis();
        yAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, yAxis);
        new BinnedDataManager.DoubleAxisListener(this.xm);
        this.xm.setBins(bins);
        this.targetBins = bins;
    }

    @Override
    JASHistData add(DataSource data) {
        if (data instanceof Rebinnable1DHistogramData) {
            Rebinnable1DHistogramData d = (Rebinnable1DHistogramData)data;
            if (d.getAxisType() != 4) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        } else {
            XYDataSource d = (XYDataSource)data;
            if (d.getAxisType() != 4) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        }
        return super.add(data);
    }

    @Override
    protected void calcMinMaxBins(double x1, double x2) {
        int binWidth = (int)(1.0 + (x2 - x1) / (double)this.targetBins);
        int bins = (int)(1.0 + (x2 - x1) / (double)binWidth);
        this.xLow = x1 - 0.5;
        double product = (double)binWidth * (double)bins;
        this.xHigh = this.xLow + product;
        double oldXMin = this.xAxis.getPlotMin();
        double oldXMax = this.xAxis.getPlotMax();
        if (this.xLow != oldXMin || this.xHigh != oldXMax) {
            this.xm.setBins(bins);
            this.xAxis.setMin(this.xLow);
            this.xAxis.setMax(this.xHigh);
            this.xAxis.getAxis().invalidate();
        }
    }
}

