/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.Basic1DFunction;
import jas2.hist.FunctionFactory;
import jas2.hist.FunctionFactoryError;
import jas2.hist.JASHist;
import jas2.hist.JASHistAxis;
import jas2.util.JASIcon;
import jas2.util.ObjectFactory;
import jas2.util.ObjectFactoryException;
import javax.swing.Icon;

public class DefaultFunctionFactory
extends ObjectFactory
implements FunctionFactory {
    private String name;
    private Icon icon = JASIcon.create(this, "function.gif");

    public DefaultFunctionFactory(Class c, String name) throws FunctionFactoryError {
        super(c);
        this.name = name;
        if (!this.inheritsFrom(Basic1DFunction.class)) {
            throw new FunctionFactoryError("Function " + name + " does not inherit from Basic1DFunction");
        }
        if (!this.checkAccess()) {
            throw new FunctionFactoryError("Function " + name + " is not declared public");
        }
        if (!this.canBeCreatedFrom(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE)) {
            throw new FunctionFactoryError("Function " + name + " does not have a suitable constructor");
        }
    }

    @Override
    public Basic1DFunction createFunction(JASHist h) throws FunctionFactoryError {
        try {
            JASHistAxis xAxis = h.getXAxis();
            JASHistAxis yAxis = h.getYAxis();
            return (Basic1DFunction)this.create(new Double(xAxis.getMin()), new Double(xAxis.getMax()), new Double(yAxis.getMin()), new Double(yAxis.getMax()));
        }
        catch (ObjectFactoryException e) {
            throw new FunctionFactoryError("Unexpected failure to create function");
        }
    }

    @Override
    public String getFunctionName() {
        return this.name;
    }

    @Override
    public Icon getFunctionIcon() {
        return this.icon;
    }
}

