/*
 * Decompiled with CFR 0.152.
 */
package jas2.cuts;

import jas2.cuts.DoubleCutPanel;
import jas2.hist.JASHist;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.jds.interfaces.CutInterface;
import jas2.jds.interfaces.CutProperties;
import jas2.swingstudio.CutAdjustmentDialog;
import jas2.swingstudio.CutDialogPanel;
import jas2.swingstudio.HasPlot;
import jas2.swingstudio.HasSlider;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleCutAdjustmentDialog
extends CutAdjustmentDialog
implements HasSlider,
HasPlot {
    private DoubleCutPanel m_panel = (DoubleCutPanel)this.getPropertiesPanel();
    private JTextField m_cutoffField = this.m_panel.getCutoffField();

    public DoubleCutAdjustmentDialog(CutInterface peer, CutProperties initialProperties) {
        super(peer, initialProperties, new DoubleCutPanel());
    }

    @Override
    public CutDialogPanel getSliderPanel(CutInterface peer) {
        return new SliderPanel(peer);
    }

    @Override
    public CutDialogPanel getPlotPanel(CutInterface peer) {
        Object o = peer.getValuesApplied();
        if (o instanceof Rebinnable1DHistogramData) {
            return new PlotPanel((Rebinnable1DHistogramData)o);
        }
        return null;
    }

    private class SliderPanel
    extends CutDialogPanel
    implements ActionListener {
        private CutInterface m_peer;
        private boolean m_ignoreChangeEvents;
        private double m_rangeMin;
        private double m_rangeMax;
        private double m_cutoffValue;
        private final JTextField m_minField;
        private final JTextField m_maxField;
        private final JSlider m_slider;
        private final NumberFormat m_format;

        SliderPanel(CutInterface peer) {
            super(new BorderLayout());
            this.m_ignoreChangeEvents = false;
            this.m_minField = new JTextField(4);
            this.m_maxField = new JTextField(4);
            this.m_slider = new JSlider();
            this.m_format = NumberFormat.getInstance();
            this.m_peer = peer;
            this.add("West", this.m_minField);
            this.add("East", this.m_maxField);
            this.add("Center", this.m_slider);
            this.m_minField.addActionListener(this);
            this.m_maxField.addActionListener(this);
            DoubleCutAdjustmentDialog.this.m_cutoffField.addActionListener(this);
            this.m_slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (SliderPanel.this.m_ignoreChangeEvents) {
                        return;
                    }
                    SliderPanel.this.m_cutoffValue = (SliderPanel.this.m_rangeMax - SliderPanel.this.m_rangeMin) * (double)SliderPanel.this.m_slider.getValue() / 100.0 + SliderPanel.this.m_rangeMin;
                    DoubleCutAdjustmentDialog.this.m_cutoffField.setText(SliderPanel.this.m_format.format(SliderPanel.this.m_cutoffValue));
                    DoubleCutAdjustmentDialog.this.changeNotify(true);
                }
            });
            this.m_format.setMaximumFractionDigits(3);
            this.m_format.setGroupingUsed(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField source = (JTextField)e.getSource();
            String text = source.getText();
            try {
                double value = Double.valueOf(text);
                if (source == DoubleCutAdjustmentDialog.this.m_cutoffField) {
                    this.m_cutoffValue = value;
                    if (this.m_cutoffValue < this.m_rangeMin) {
                        this.m_rangeMin = this.m_cutoffValue;
                        this.m_minField.setText(this.m_format.format(this.m_rangeMin));
                    } else if (this.m_cutoffValue > this.m_rangeMax) {
                        this.m_rangeMax = this.m_cutoffValue;
                        this.m_maxField.setText(this.m_format.format(this.m_rangeMax));
                    }
                } else {
                    if (source == this.m_minField && value >= this.m_rangeMax || source == this.m_maxField && this.m_rangeMin >= value) {
                        JOptionPane.showMessageDialog(DoubleCutAdjustmentDialog.this, "min must be less than max", "Error", 0);
                        return;
                    }
                    if (source == this.m_minField) {
                        this.m_rangeMin = value;
                    } else {
                        this.m_rangeMax = value;
                    }
                }
                this.setSliderPosition();
            }
            catch (NumberFormatException x) {
                JOptionPane.showMessageDialog(DoubleCutAdjustmentDialog.this, "\"" + text + "\" is not a number", "Error", 0);
            }
        }

        @Override
        public boolean beforeShowing() {
            String value = DoubleCutAdjustmentDialog.this.m_cutoffField.getText();
            try {
                this.m_cutoffValue = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(DoubleCutAdjustmentDialog.this, "\"" + value + "\" is not a number", "Error", 0);
                return false;
            }
            Rebinnable1DHistogramData data = (Rebinnable1DHistogramData)this.m_peer.getValuesApplied();
            this.m_rangeMin = Math.min(this.m_cutoffValue, data != null ? data.getMin() : 0.0);
            this.m_rangeMax = Math.max(this.m_cutoffValue, data != null ? data.getMax() : 10.0);
            this.m_minField.setText(this.m_format.format(this.m_rangeMin));
            this.m_maxField.setText(this.m_format.format(this.m_rangeMax));
            this.setSliderPosition();
            return true;
        }

        @Override
        public void afterClosing() {
            DoubleCutAdjustmentDialog.this.m_cutoffField.removeActionListener(this);
        }

        private void setSliderPosition() {
            this.m_ignoreChangeEvents = true;
            this.m_slider.setValue((int)((this.m_cutoffValue - this.m_rangeMin) * 100.0 / (this.m_rangeMax - this.m_rangeMin)));
            this.m_ignoreChangeEvents = false;
        }
    }

    private class PlotPanel
    extends CutDialogPanel {
        private final JASHist m_plot;
        private final Rebinnable1DHistogramData m_data;

        PlotPanel(Rebinnable1DHistogramData data) {
            super(new BorderLayout());
            this.m_plot = new JASHist();
            this.m_plot.setPreferredSize(new Dimension(150, 150));
            this.add("Center", this.m_plot);
            this.m_data = data;
        }

        @Override
        public void afterClosing() {
            this.m_plot.removeAllData();
        }

        @Override
        public boolean beforeShowing() {
            this.m_plot.addData(this.m_data).show(true);
            return true;
        }
    }
}

