/*
 * Decompiled with CFR 0.152.
 */
package jas2.bean;

import jas2.hist.DataSource;
import jas2.hist.HasDataSource;
import jas2.job.HistogramAccess;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeAdaptorSite;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.tree.TreeModel;

public class TreeDataSourceProvider
implements HasDataSource {
    @Override
    public DataSource getDataSource(String param) throws IllegalArgumentException {
        TreeModel model = JavaAnalysisStudio.getApp().getTreeModel();
        TreeAdaptorSite node = this.findNode(model, param);
        Object source = node.getAssociatedObject();
        if (source instanceof DataSource) {
            return (DataSource)source;
        }
        if (source instanceof HistogramAccess) {
            return ((HistogramAccess)source).getData();
        }
        throw new IllegalArgumentException("Path did not lead to a DataSource " + source.getClass());
    }

    protected TreeAdaptorSite findNode(TreeModel model, String path) throws IllegalArgumentException {
        TreeAdaptorSite node = (TreeAdaptorSite)model.getRoot();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            TreeAdaptorSite child;
            TreeAdaptorSite newNode = null;
            String token = tokenizer.nextToken();
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                child = (TreeAdaptorSite)children.nextElement();
                if (!child.getName().equals(token)) continue;
                newNode = child;
                break;
            }
            if (newNode == null) {
                children = node.children();
                while (children.hasMoreElements()) {
                    child = (TreeAdaptorSite)children.nextElement();
                    if (!child.getName().equalsIgnoreCase(token)) continue;
                    newNode = child;
                    break;
                }
                if (newNode == null) {
                    throw new IllegalArgumentException("Node " + token + " in " + path + " not found");
                }
            }
            node = newNode;
        }
        return node;
    }
}

