/*
 * Decompiled with CFR 0.152.
 */
package jas2.bean;

import jas2.bean.Plot;
import java.awt.Color;
import java.awt.Dimension;

public class QuickPlot
extends Plot {
    private boolean m_yAxisLogarithmic;
    private boolean m_yAxisAllowSuppressedZero;

    public QuickPlot() {
        this.m_hist.setBackground(Color.white);
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.m_hist.getYAxis().setLogarithmic(this.m_yAxisLogarithmic);
        this.m_hist.getYAxis().setAllowSuppressedZero(this.m_yAxisAllowSuppressedZero);
    }

    public String getPlotHeight() {
        Dimension dim = this.getPreferredSize();
        return Integer.toString(dim.height);
    }

    public void setPlotHeight(String heightValue) {
        try {
            Dimension dim = this.getPreferredSize();
            dim.height = Integer.parseInt(heightValue);
            this.setPreferredSize(dim);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getPlotWidth() {
        Dimension dim = this.getPreferredSize();
        return Integer.toString(dim.width);
    }

    public void setPlotWidth(String widthValue) {
        try {
            Dimension dim = this.getPreferredSize();
            dim.width = Integer.parseInt(widthValue);
            this.setPreferredSize(dim);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getBackgroundColor() {
        return this.m_hist.getBackground().toString();
    }

    public void setBackgroundColor(String colorValue) {
        try {
            Color color = Color.decode(colorValue);
            this.m_hist.setBackground(color);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getXAxisLogarithmic() {
        return this.m_hist.getXAxis().isLogarithmic() ? "true" : "false";
    }

    public void setXAxisLogarithmic(String isLogValue) {
        Boolean isLog = new Boolean(isLogValue);
        this.m_hist.getXAxis().setLogarithmic(isLog);
    }

    public String getYAxisLogarithmic() {
        return this.m_hist.getYAxis().isLogarithmic() ? "true" : "false";
    }

    public void setYAxisLogarithmic(String isLogValue) {
        Boolean isLog = new Boolean(isLogValue);
        this.m_yAxisLogarithmic = isLog;
        this.m_hist.getYAxis().setLogarithmic(this.m_yAxisLogarithmic);
    }

    public String getXAxisAllowSuppressedZero() {
        return this.m_hist.getXAxis().getAllowSuppressedZero() ? "true" : "false";
    }

    public void setXAxisAllowSupressedZero(String allowValue) {
        Boolean allow = new Boolean(allowValue);
        this.m_hist.getXAxis().setAllowSuppressedZero(allow);
    }

    public String getYAxisAllowSuppressedZero() {
        return this.m_hist.getYAxis().getAllowSuppressedZero() ? "true" : "false";
    }

    public void setYAxisAllowSupressedZero(String allowValue) {
        Boolean allow = new Boolean(allowValue);
        this.m_yAxisAllowSuppressedZero = allow;
        this.m_hist.getYAxis().setAllowSuppressedZero(this.m_yAxisAllowSuppressedZero);
    }
}

