/*
 * Decompiled with CFR 0.152.
 */
package jas2.bean;

import jas2.bean.PageContext;
import jas2.bean.PageContextHook;
import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.job.HistogramAccess;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeAdaptorSite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;

public class Plot
extends JPanel
implements PageContextHook {
    protected String m_data;
    protected JASHist m_hist = new JASHist();

    public Plot() {
        super(new BorderLayout());
        this.add((Component)this.m_hist, "Center");
        this.setPreferredSize(new Dimension(200, 200));
    }

    public void setData(String data) {
        this.m_data = data;
    }

    public String getData() {
        return this.m_data;
    }

    private void showData() throws Exception {
        JavaAnalysisStudio app = JavaAnalysisStudio.getApp();
        TreeModel model = app.getTreeModel();
        StringTokenizer pathTokenizer = new StringTokenizer(this.m_data, ":");
        while (pathTokenizer.hasMoreTokens()) {
            JASHistData hist_data;
            String path = pathTokenizer.nextToken();
            TreeAdaptorSite node = this.findNode(model, path);
            Object source = node.getAssociatedObject();
            if (source instanceof DataSource) {
                hist_data = this.m_hist.addData((DataSource)source);
                hist_data.show(true);
                continue;
            }
            if (source instanceof HistogramAccess) {
                hist_data = this.m_hist.addData(((HistogramAccess)source).getData());
                hist_data.show(true);
                continue;
            }
            throw new IllegalArgumentException("Path " + path + " does not lead to data");
        }
    }

    protected TreeAdaptorSite findNode(TreeModel model, String path) throws IllegalArgumentException {
        TreeAdaptorSite node = (TreeAdaptorSite)model.getRoot();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            TreeAdaptorSite newNode = null;
            String token = tokenizer.nextToken();
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                TreeAdaptorSite child = (TreeAdaptorSite)children.nextElement();
                if (!child.getName().equals(token)) continue;
                newNode = child;
                break;
            }
            if (newNode == null) {
                throw new IllegalArgumentException("Node " + token + " in " + path + " not found");
            }
            node = newNode;
        }
        return node;
    }

    @Override
    public void init(PageContext context) throws Exception {
        if (this.m_data != null) {
            this.showData();
        }
    }

    @Override
    public void destroy() {
        this.m_hist.destroy();
    }
}

