/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.BadTableHtmlException;
import htmllayout.HtmlLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.util.Hashtable;

class Cell {
    int hfill = 0;
    int vfill = 2;
    String name;
    HtmlLayout nested;
    String labelText;
    Component comp;
    int row;
    int col;
    int rowspan = 1;
    int colspan = 1;
    int hgap;
    int vgap;
    int hpad;
    int vpad;
    private int reqwidth;
    private int reqheight;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);

    Cell(int hg, int vg, int hp, int vp) {
        this.hgap = hg;
        this.vgap = vg;
        this.hpad = hp;
        this.vpad = vp;
    }

    void addToNameTable(Hashtable nameToCell) {
        if (this.name != null) {
            if (nameToCell.put(this.name, this) != null) {
                throw new BadTableHtmlException("Duplicate component name: " + this.name);
            }
        } else if (this.nested != null) {
            this.nested.addCellsToTable(nameToCell);
        }
    }

    void addLabels(Container parent) {
        if (this.labelText != null && this.comp == null) {
            this.comp = new Label(this.labelText);
            parent.add(this.comp, HtmlLayout.anonLabelName);
        } else if (this.nested != null) {
            this.nested.addLabels(parent);
        }
    }

    void finalLayout(int[] xpos, int[] ypos) {
        if (this.comp == null && this.nested == null) {
            return;
        }
        int r = this.row + this.rowspan;
        int c = this.col + this.colspan;
        int ll = xpos[this.col];
        int lt = ypos[this.row];
        int mr = xpos[c];
        int mb = ypos[r];
        int left = ll;
        int right = mr;
        int top = lt;
        int bottom = mb;
        if (this.col != 0) {
            left += this.hgap;
        }
        if (this.row != 0) {
            top += this.vgap;
        }
        if (this.hfill != 4 && this.hfill != 3) {
            left = HtmlLayout.calcTopOrLeft(left, right, this.reqwidth, this.hfill);
            right = left + this.reqwidth;
        }
        if (this.vfill != 4 && this.vfill != 3) {
            top = HtmlLayout.calcTopOrLeft(top, bottom, this.reqheight, this.vfill);
            bottom = top + this.reqheight;
        }
        this.position(ll, lt, mr, mb, left, top, right, bottom);
    }

    private void position(int ll, int lt, int mr, int mb, int l, int t, int r, int b) {
        if (l < ll) {
            l = ll;
        }
        if (t < lt) {
            t = lt;
        }
        if (r > mr) {
            r = mr;
        }
        if (b > mb) {
            b = mb;
        }
        if (this.comp != null) {
            this.comp.setBounds(l, t, r - l, b - t);
        } else {
            this.nested.layout(t, b, l, r);
        }
    }

    void firstXLayout(int[] xpos, boolean[] wantX) {
        this.addToXTable(xpos);
        if (this.hfill == 4) {
            for (int i = this.col; i < this.col + this.colspan; ++i) {
                wantX[i] = true;
            }
        }
    }

    void firstYLayout(int[] ypos, boolean[] wantY) {
        this.addToYTable(ypos);
        if (this.vfill == 4) {
            for (int i = this.row; i < this.row + this.rowspan; ++i) {
                wantY[i] = true;
            }
        }
    }

    void updateSize(int whichSize) {
        Dimension d = this.getSize(whichSize);
        this.reqwidth = d.width;
        this.reqheight = d.height;
    }

    private void squeeze(int[] pos, int[][] touch, int[] count, int[] limit, int start, int end, int size) {
        int availsize = pos[end] - pos[start];
        if (availsize > size) {
            int mylimit = availsize - size;
            if (mylimit < limit[end]) {
                limit[end] = mylimit;
            }
        } else {
            int n = end;
            int n2 = count[n];
            count[n] = n2 + 1;
            touch[end][n2] = start;
        }
    }

    void squeezeX(int[] xpos, int[][] touch, int[] count, int[] limit) {
        this.squeeze(xpos, touch, count, limit, this.col, this.col + this.colspan, this.reqwidth + (this.col == 0 ? 0 : this.hgap));
    }

    void squeezeY(int[] ypos, int[][] touch, int[] count, int[] limit) {
        this.squeeze(ypos, touch, count, limit, this.row, this.row + this.rowspan, this.reqheight + (this.row == 0 ? 0 : this.vgap));
    }

    void addToXTable(int[] xpos) {
        int c = this.col + this.colspan;
        int right = xpos[this.col] + this.reqwidth + (this.col == 0 ? 0 : this.hgap);
        if (xpos[c] < right) {
            xpos[c] = right;
        }
    }

    void addToYTable(int[] ypos) {
        int r = this.row + this.rowspan;
        int bottom = ypos[this.row] + this.reqheight + (this.row == 0 ? 0 : this.vgap);
        if (ypos[r] < bottom) {
            ypos[r] = bottom;
        }
    }

    Dimension getSize(int whichSize) {
        Dimension d;
        if (this.nested != null) {
            return this.nested.layoutSize(zeroInsets, whichSize);
        }
        if (this.comp == null || !this.comp.isVisible()) {
            return new Dimension(0, 0);
        }
        if (whichSize == 0) {
            d = this.comp.getMinimumSize();
        } else if (whichSize == 1) {
            d = this.comp.getPreferredSize();
        } else {
            throw new IllegalArgumentException("Bad whichSize " + whichSize);
        }
        if (this.vpad != 0 || this.hpad != 0) {
            d = new Dimension(d.width + this.hpad, d.height + this.vpad);
        }
        return d;
    }

    private String descString() {
        return " pos = " + this.row + ", " + this.col + " span = " + this.rowspan + ", " + this.colspan + " fill = " + this.hfill + ", " + this.vfill + " gap = " + this.hgap + ", " + this.vgap + " pad = " + this.hpad + ", " + this.vpad + (this.name != null ? " name = " + this.name : (this.nested != null ? " nested = " : (this.labelText != null ? " label = " + this.labelText : " empty ")));
    }

    void dump(int space) {
        for (int i = 0; i < space; ++i) {
            System.err.print(' ');
        }
        System.err.println("Cell" + this.descString());
        if (this.nested != null) {
            this.nested.dump(space + 3);
        }
    }

    public String toString() {
        return "[Cell pos = " + this.descString() + (this.nested != null ? this.nested.toString() : "") + "]";
    }
}

