/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics.generator.diagnostic;

import hepjas.analysis.EndOfDataException;
import hepjas.analysis.EventData;
import hepjas.analysis.EventGenerator;
import hepjas.physics.BasicHep3Matrix;
import hepjas.physics.BasicHep3Vector;
import hepjas.physics.BasicHepLorentzVector;
import hepjas.physics.Hep3Vector;
import hepjas.physics.HepLorentzVector;
import hepjas.physics.ParticleProperties;
import hepjas.physics.ParticleType;
import hepjas.physics.UnknownParticleID;
import hepjas.physics.VecOp;
import hepjas.physics.generator.event.GeneratorEvent;
import hepjas.physics.generator.event.GeneratorParticle;
import hepjas.physics.generator.event.GeneratorParticleVector;
import java.util.Random;

public class DiagnosticEventGenerator
extends EventGenerator {
    private int m_imaxEvents = 100;
    private int m_ievent;
    private int m_irun = 1;
    private ParticleType m_ptype;
    private ParticleType m_ptypeBar;
    private int m_inparts = 1;
    private double m_dlowp = 5.0;
    private double m_dhighp = 5.0;
    private double m_dlowcosth = -1.0;
    private double m_dhighcosth = 1.0;
    private double m_dlowphi = 0.0;
    private double m_dhighphi = Math.PI * 2;
    private BasicHep3Vector m_origin = new BasicHep3Vector(0.0, 0.0, 0.0);
    private double m_dxrange = 0.0;
    private double m_dyrange = 0.0;
    private double m_dzrange = 0.0;
    private double m_dangres = -1.0;
    boolean m_bseedset = false;
    private long m_lseed;
    private Random myRandom;
    boolean m_branPPBar = false;
    boolean m_addFakeMother = true;

    public DiagnosticEventGenerator() {
        this.setParticleType(13);
        this.myRandom = new Random();
    }

    @Override
    public String getName() {
        return "Diagnostic Generator";
    }

    @Override
    public void beforeFirstEvent() {
        this.m_bseedset = true;
        if (true) {
            this.myRandom.setSeed(this.m_lseed);
        }
        this.m_ievent = 0;
    }

    public void setMaxEvents(int n) {
        this.m_imaxEvents = n;
    }

    public int getMaxEvents() {
        return this.m_imaxEvents;
    }

    @Override
    public int getTotalNumberOfEvents() {
        return this.m_imaxEvents > 0 ? this.m_imaxEvents : -1;
    }

    public void setRunNumber(int nrun) {
        this.m_irun = nrun;
    }

    public void setParticleType(int pdgid) {
        this.setParticleType(ParticleProperties.get(pdgid));
    }

    public void setParticleType(ParticleType ptype) {
        this.m_ptype = ptype;
        try {
            this.m_ptypeBar = ParticleProperties.get(-1 * ptype.getPDGID());
            this.m_ptypeBar.getMass();
        }
        catch (UnknownParticleID x) {
            this.m_ptypeBar = ptype;
        }
    }

    public void addFakeMother(boolean doIt) {
        this.m_addFakeMother = doIt;
    }

    public ParticleType getParticleType() {
        return this.m_ptype;
    }

    public void setNumberOfParticles(int nparts) {
        if (nparts < 1) {
            throw new IllegalArgumentException("Invalid number of particles.");
        }
        this.m_inparts = nparts;
    }

    public int getNumberOfParticles() {
        return this.m_inparts;
    }

    public void setMomentumRange(double lowp, double highp) {
        if (lowp < 0.0 | highp <= 0.0 | lowp > highp) {
            throw new IllegalArgumentException("Invalid momentum range value.");
        }
        this.m_dlowp = lowp;
        this.m_dhighp = highp;
    }

    public void setCosthRange(double lowcosth, double highcosth) {
        if (lowcosth < -1.0 | highcosth > 1.0 | lowcosth > highcosth) {
            throw new IllegalArgumentException("Invalid costheta range value.");
        }
        this.m_dlowcosth = lowcosth;
        this.m_dhighcosth = highcosth;
    }

    public void setPhiRange(double lowphi, double highphi) {
        if (lowphi > highphi) {
            throw new IllegalArgumentException("Invalid phi range value.");
        }
        this.m_dlowphi = lowphi;
        this.m_dhighphi = highphi;
    }

    public void setOrigin(double x, double y, double z) {
        this.m_origin.setV(x, y, z);
    }

    public void setXRange(double dx) {
        this.m_dxrange = dx;
    }

    public void setYRange(double dy) {
        this.m_dyrange = dy;
    }

    public void setZRange(double dz) {
        this.m_dzrange = dz;
    }

    public void setRandomParticleAntiParticle(boolean ppbar) {
        this.m_branPPBar = ppbar;
    }

    public void setTwoParticleRes(double angres) {
        this.m_dangres = angres;
    }

    public void setSeed(long seed) {
        this.m_lseed = seed;
        this.m_bseedset = true;
    }

    public void printParameters() {
        System.out.println("Diagnostic Generator Parameter Settings.");
        System.out.println("Particle type = " + this.m_ptype);
        System.out.println("Number of particles per event = " + this.m_inparts);
        System.out.println("Momentum range = (" + this.m_dlowp + ", " + this.m_dhighp + ")");
        System.out.println("Cosine theta range = (" + this.m_dlowcosth + ", " + this.m_dhighcosth + ")");
        System.out.println("Phi range = (" + this.m_dlowphi + ", " + this.m_dhighphi + ")");
        System.out.println("Particle origin = (" + this.m_origin.x() + ", " + this.m_origin.y() + ", " + this.m_origin.z() + ")");
        System.out.println("Origin ranges = (" + this.m_dxrange + ", " + this.m_dyrange + ", " + this.m_dzrange + ")");
        System.out.println("Angular resolution = " + this.m_dangres);
        System.out.println("Random number seed = " + this.m_lseed);
    }

    @Override
    public EventData generateEvent() throws EndOfDataException {
        if (this.m_imaxEvents > 0 && this.m_ievent >= this.m_imaxEvents) {
            throw new EndOfDataException();
        }
        GeneratorParticleVector partVec = this.m_dangres < 0.0 ? new GeneratorParticleVector(this.m_inparts + 1) : new GeneratorParticleVector(2 * this.m_inparts + 1);
        for (int i = 0; i < this.m_inparts; ++i) {
            GeneratorParticle mother = new GeneratorParticle();
            if (this.m_addFakeMother) {
                mother.setStatusCode(3);
                mother.setProductionTime(0.0);
                mother.setOrigin(new BasicHep3Vector(0.0, 0.0, 0.0));
                mother.setType(ParticleProperties.get(99999999));
                mother.setP(new BasicHepLorentzVector(0.0, 0.0, 0.0, 0.0));
                partVec.addElement(mother);
            }
            GeneratorParticle part = new GeneratorParticle();
            part.setStatusCode(1);
            part.setProductionTime(0.0);
            if (this.m_branPPBar && this.myRandom.nextDouble() < 0.5) {
                part.setType(this.m_ptypeBar);
            } else {
                part.setType(this.m_ptype);
            }
            Hep3Vector origin = this.selectOrigin();
            part.setOrigin(origin);
            HepLorentzVector p = this.selectP();
            part.setP(p);
            if (this.m_addFakeMother) {
                part.addParent(mother);
            }
            partVec.addElement(part);
            if (!(this.m_dangres >= 0.0)) continue;
            BasicHep3Vector v = new BasicHep3Vector(0.0, 0.0, p.v3().mag());
            double ranphi = Math.PI * 2 * this.myRandom.nextDouble();
            BasicHep3Matrix rot = new BasicHep3Matrix();
            rot.setActiveEuler(ranphi, this.m_dangres, 0.0);
            Hep3Vector vtwin = new BasicHep3Vector();
            vtwin = VecOp.mult(rot, (Hep3Vector)v);
            double theta = Math.acos(p.v3().z() / p.v3().mag());
            BasicHep3Vector pprojxy = new BasicHep3Vector(p.v3().x(), p.v3().y(), 0.0);
            double xymag = pprojxy.mag();
            int signy = 1;
            if (p.v3().y() < 0.0) {
                signy = -1;
            }
            double phi = xymag > 0.0 ? (double)signy * Math.acos(p.v3().x() / xymag) : 0.0;
            rot.setActiveEuler(1.5707963267948966 + phi, theta, 0.0);
            BasicHepLorentzVector ptwin = new BasicHepLorentzVector(p.t(), VecOp.mult(rot, vtwin));
            GeneratorParticle twin = new GeneratorParticle();
            twin.setStatusCode(1);
            twin.setProductionTime(0.0);
            if (this.m_branPPBar && this.myRandom.nextDouble() < 0.5) {
                twin.setType(this.m_ptypeBar);
            } else {
                twin.setType(this.m_ptype);
            }
            twin.setOrigin(origin);
            twin.setP(ptwin);
            if (this.m_addFakeMother) {
                twin.addParent(mother);
            }
            partVec.addElement(twin);
        }
        ++this.m_ievent;
        return new GeneratorEvent(this.m_irun, this.m_ievent, partVec);
    }

    public void getSummary() {
    }

    protected HepLorentzVector selectP() {
        double mom = this.selectMom();
        double theta = Math.acos(this.selectCosth());
        double phi = this.selectPhi();
        double px = mom * Math.sin(theta) * Math.cos(phi);
        double py = mom * Math.sin(theta) * Math.sin(phi);
        double pz = mom * Math.cos(theta);
        double mass = this.m_ptype.getMass();
        double energy = Math.sqrt(mass * mass + mom * mom);
        return new BasicHepLorentzVector(energy, px, py, pz);
    }

    protected Hep3Vector selectOrigin() {
        double ran = this.myRandom.nextDouble();
        double x = this.m_origin.x() + this.m_dxrange * (ran - 0.5);
        ran = this.myRandom.nextDouble();
        double y = this.m_origin.y() + this.m_dyrange * (ran - 0.5);
        ran = this.myRandom.nextDouble();
        double z = this.m_origin.z() + this.m_dzrange * (ran - 0.5);
        BasicHep3Vector origin = new BasicHep3Vector(x, y, z);
        return origin;
    }

    protected double selectMom() {
        if (this.m_dlowp == this.m_dhighp) {
            return this.m_dlowp;
        }
        if (this.m_dlowp > 0.0) {
            return this.m_dlowp + (this.m_dhighp - this.m_dlowp) * this.myRandom.nextDouble();
        }
        double ran = 0.0;
        while (ran == 0.0) {
            ran = this.myRandom.nextDouble();
        }
        return this.m_dlowp + (this.m_dhighp - this.m_dlowp) * ran;
    }

    protected double selectCosth() {
        if (this.m_dlowcosth == this.m_dhighcosth) {
            return this.m_dlowcosth;
        }
        return this.m_dlowcosth + (this.m_dhighcosth - this.m_dlowcosth) * this.myRandom.nextDouble();
    }

    protected double selectPhi() {
        if (this.m_dlowphi == this.m_dhighphi) {
            return this.m_dlowphi;
        }
        return this.m_dlowphi + (this.m_dhighphi - this.m_dlowphi) * this.myRandom.nextDouble();
    }
}

