/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics;

import hepjas.physics.Hep3Vector;
import hepjas.physics.VecOp;
import java.io.Serializable;

public class BasicHep3Vector
implements Hep3Vector,
Serializable {
    private double m_dx;
    private double m_dy;
    private double m_dz;

    public BasicHep3Vector() {
        this.m_dx = 0.0;
        this.m_dy = 0.0;
        this.m_dz = 0.0;
    }

    public BasicHep3Vector(double dx, double dy, double dz) {
        this.m_dx = dx;
        this.m_dy = dy;
        this.m_dz = dz;
    }

    public BasicHep3Vector(double[] d) {
        if (d.length != 3) {
            throw new IllegalArgumentException("Illegal array length");
        }
        this.m_dx = d[0];
        this.m_dy = d[1];
        this.m_dz = d[2];
    }

    public void setV(double dx, double dy, double dz) {
        this.m_dx = dx;
        this.m_dy = dy;
        this.m_dz = dz;
    }

    @Override
    public double[] v() {
        double[] elements = new double[]{this.m_dx, this.m_dy, this.m_dz};
        return elements;
    }

    @Override
    public double x() {
        return this.m_dx;
    }

    @Override
    public double y() {
        return this.m_dy;
    }

    @Override
    public double z() {
        return this.m_dz;
    }

    @Override
    public double mag() {
        return Math.sqrt(this.mag2());
    }

    @Override
    public double mag2() {
        return VecOp.dot(this, this);
    }

    @Override
    public double cosTheta() {
        return this.z() / this.mag();
    }
}

