/*
 * Decompiled with CFR 0.152.
 */
package hepjas.io.stdhep.adapter;

import hep.io.stdhep.StdhepEvent;
import hepjas.analysis.EventHeader;
import hepjas.io.stdhep.adapter.HepEvent;
import hepjas.physics.Particle;
import hepjas.physics.ParticleEnumeration;
import hepjas.physics.ParticleVector;

public class StdhepAdapter {
    private Particle[] particles;

    public EventHeader convert(StdhepEvent stdhep) {
        return new HepEvent(stdhep);
    }

    public StdhepEvent convert(EventHeader event) {
        ParticleVector pv = (ParticleVector)event.get("MCParticles");
        int nevhep = event.getEventNumber();
        int nhep = pv.size();
        double[] phep = new double[5 * nhep];
        double[] vhep = new double[4 * nhep];
        int[] isthep = new int[nhep];
        int[] idhep = new int[nhep];
        int[] jmohep = new int[2 * nhep];
        int[] jdahep = new int[2 * nhep];
        int j = 0;
        int k = 0;
        int l = 0;
        int m = 0;
        this.particles = new Particle[nhep];
        ParticleEnumeration e = pv.particles();
        int i = 0;
        while (e.hasMoreParticles()) {
            this.particles[i] = e.nextParticle();
            ++i;
        }
        for (i = 0; i < nhep; ++i) {
            Particle firstDaughter;
            Particle particle = this.particles[i];
            idhep[i] = particle.getType().getPDGID();
            isthep[i] = particle.getStatusCode();
            phep[j++] = particle.getPX();
            phep[j++] = particle.getPY();
            phep[j++] = particle.getPZ();
            phep[j++] = particle.getEnergy();
            phep[j++] = particle.getMass();
            vhep[k++] = particle.getOriginX();
            vhep[k++] = particle.getOriginY();
            vhep[k++] = particle.getOriginZ();
            vhep[k++] = particle.getProductionTime();
            ParticleEnumeration parents = particle.getParents();
            jmohep[l++] = parents.hasMoreParticles() ? this.indexOf(parents.nextParticle()) : 0;
            jmohep[l++] = parents.hasMoreParticles() ? this.indexOf(parents.nextParticle()) : 0;
            ParticleEnumeration daughters = particle.getDaughters();
            if (!daughters.hasMoreParticles()) {
                jdahep[m++] = 0;
                jdahep[m++] = -1;
                continue;
            }
            Particle lastDaughter = firstDaughter = daughters.nextParticle();
            int n = this.indexOf(firstDaughter) + 1;
            while (daughters.hasMoreParticles()) {
                lastDaughter = daughters.nextParticle();
                if (this.indexOf(lastDaughter) != n) {
                    throw new RuntimeException("Daughters are not consecutive");
                }
                ++n;
            }
            jdahep[m++] = this.indexOf(firstDaughter);
            jdahep[m++] = this.indexOf(lastDaughter);
        }
        this.particles = null;
        return new StdhepEvent(nevhep, nhep, isthep, idhep, jmohep, jdahep, phep, vhep);
    }

    private int indexOf(Particle p) {
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] != p) continue;
            return i + 1;
        }
        return 0;
    }
}

