/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.SimpleTwoDDataSource;
import hepjas.analysis.partition.TwoDBinner;
import java.io.Serializable;

public class TwoDBinTypeAdapter
implements TwoDBinner,
SimpleTwoDDataSource,
Serializable {
    private int xBins;
    private int yBins;
    private BinType type;
    static final long serialVersionUID = -3741465661266122772L;

    TwoDBinTypeAdapter(BinType type, int xBins, int yBins) {
        this.type = type;
        this.xBins = xBins;
        this.yBins = yBins;
        type.clear();
        type.setNumberOfBins(xBins * yBins);
    }

    @Override
    public void fill(int xBin, int yBin) {
        this.type.fill(yBin * this.xBins + xBin);
    }

    @Override
    public void fillW(int xBin, int yBin, double value) {
        this.type.fillW(yBin * this.xBins + xBin, value);
    }

    @Override
    public void clear() {
        this.type.clear();
    }

    @Override
    public void setNumberOfBins(int xBins, int yBins) {
        this.clear();
        this.xBins = xBins;
        this.yBins = yBins;
        this.type.setNumberOfBins(xBins * yBins);
    }

    @Override
    public int getNumberOfXBins() {
        return this.xBins;
    }

    @Override
    public int getNumberOfYBins() {
        return this.yBins;
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        return this.type.hasSimpleQuadraticErrorBars();
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        return this.type.hasAsymmetricErrorBars();
    }

    @Override
    public double[][] getBins() {
        int k = 0;
        double[] bins = this.type.getBins();
        double[][] result = new double[this.xBins][this.yBins];
        for (int j = 0; j < this.yBins; ++j) {
            for (int i = 0; i < this.xBins; ++i) {
                result[i][j] = bins[k++];
            }
        }
        return result;
    }

    @Override
    public double[][] getPlusErrors() {
        int k = 0;
        double[] bins = this.type.getPlusErrors();
        double[][] result = new double[this.xBins][this.yBins];
        for (int j = 0; j < this.yBins; ++j) {
            for (int i = 0; i < this.xBins; ++i) {
                result[i][j] = bins[k++];
            }
        }
        return result;
    }

    @Override
    public double[][] getMinusErrors() {
        int k = 0;
        double[] bins = this.type.getMinusErrors();
        double[][] result = new double[this.xBins][this.yBins];
        for (int j = 0; j < this.yBins; ++j) {
            for (int i = 0; i < this.xBins; ++i) {
                result[i][j] = bins[k++];
            }
        }
        return result;
    }
}

