/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.BinFinder;
import hepjas.analysis.partition.TwoDBinner;
import hepjas.analysis.partition.TwoDFillable;
import java.io.Serializable;
import java.util.Date;

public class TwoDBinAdapter
implements TwoDFillable,
Serializable {
    private BinFinder xFinder;
    private BinFinder yFinder;
    private TwoDBinner binner;
    static final long serialVersionUID = -1607932191464564314L;

    TwoDBinAdapter(BinFinder xFinder, BinFinder yFinder, TwoDBinner binner) {
        this.xFinder = xFinder;
        this.yFinder = yFinder;
        this.binner = binner;
    }

    @Override
    public void fill(double x, double y) {
        int xBin = this.xFinder.getBinAt(x);
        int yBin = this.yFinder.getBinAt(y);
        if (xBin >= 0 && yBin >= 0) {
            this.binner.fill(xBin, yBin);
        }
    }

    @Override
    public void fillW(double x, double y, double weight) {
        int xBin = this.xFinder.getBinAt(x);
        int yBin = this.yFinder.getBinAt(y);
        if (xBin >= 0 && yBin >= 0) {
            this.binner.fillW(xBin, yBin, weight);
        }
    }

    @Override
    public void fill(Date x, double y) {
        int xBin = this.xFinder.getBinAt(x);
        int yBin = this.yFinder.getBinAt(y);
        if (xBin >= 0 && yBin >= 0) {
            this.binner.fill(xBin, yBin);
        }
    }

    @Override
    public void fillW(Date x, double y, double weight) {
        int xBin = this.xFinder.getBinAt(x);
        int yBin = this.yFinder.getBinAt(y);
        if (xBin >= 0 && yBin >= 0) {
            this.binner.fillW(xBin, yBin, weight);
        }
    }

    @Override
    public void clear() {
        this.xFinder.clear();
        this.yFinder.clear();
        this.binner.clear();
    }
}

