/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.AbstractOneDFillable;
import hepjas.analysis.partition.OneDFillable;
import hepjas.analysis.partition.PartitionEnumeration;
import hepjas.analysis.partition.PartitionVector;

public class SimpleStorer
extends AbstractOneDFillable {
    private PartitionVector m_simple = new PartitionVector(1);
    private PartitionVector m_weighted = new PartitionVector(2);
    private double[] m_currentSimple;
    private double[] m_currentWeighted;
    private int m_countSimple;
    private int m_countWeighted;
    private int m_simpleEntriesFilled;
    private int m_weightedEntriesFilled;
    static final long serialVersionUID = 50202889440605209L;

    public SimpleStorer() {
        this.clear();
    }

    @Override
    public void fill(double d) {
        try {
            this.m_currentSimple[this.m_countSimple++] = d;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_currentSimple = this.m_simple.newArray();
            this.m_countSimple = 0;
            this.m_currentSimple[this.m_countSimple++] = d;
        }
        ++this.m_simpleEntriesFilled;
    }

    @Override
    public void fillW(double d, double weight) {
        try {
            this.m_currentWeighted[this.m_countWeighted++] = d;
            this.m_currentWeighted[this.m_countWeighted++] = weight;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_currentWeighted = this.m_weighted.newArray();
            this.m_countWeighted = 0;
            this.m_currentWeighted[this.m_countWeighted++] = d;
            this.m_currentWeighted[this.m_countWeighted++] = weight;
        }
        ++this.m_weightedEntriesFilled;
    }

    public void fillData(OneDFillable fill) {
        PartitionEnumeration e = this.m_simple.elements();
        e.setEndPoint(this.m_simpleEntriesFilled);
        while (e.hasMoreElements()) {
            fill.fill(e.nextValue());
        }
        e = this.m_weighted.elements();
        e.setEndPoint(this.m_weightedEntriesFilled);
        while (e.hasMoreElements()) {
            fill.fillW(e.nextValue(), e.nextValue());
        }
    }

    @Override
    public void clear() {
        this.m_simple.clear();
        this.m_weighted.clear();
        this.m_currentSimple = this.m_simple.newArray();
        this.m_currentWeighted = this.m_weighted.newArray();
        this.m_countSimple = 0;
        this.m_countWeighted = 0;
        this.m_simpleEntriesFilled = 0;
        this.m_weightedEntriesFilled = 0;
    }
}

