/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.BinType;

public class SimpleBinner
implements BinType {
    protected int m_bins;
    protected double[] m_hist;
    protected double[] m_error;
    private boolean m_hasWeightedEntries;
    static final long serialVersionUID = 8695712331891724491L;

    public SimpleBinner(int bins) {
        if (bins < 0) {
            throw new IllegalArgumentException("bins <= 0");
        }
        this.m_bins = bins;
        this.clear();
    }

    @Override
    public void clear() {
        this.m_hist = new double[this.m_bins];
        this.m_error = new double[this.m_bins];
        this.m_hasWeightedEntries = false;
    }

    @Override
    public void fill(int bin) {
        int n = bin;
        this.m_hist[n] = this.m_hist[n] + 1.0;
        int n2 = bin;
        this.m_error[n2] = this.m_error[n2] + 1.0;
    }

    @Override
    public void fillW(int bin, double v) {
        int n = bin;
        this.m_hist[n] = this.m_hist[n] + v;
        int n2 = bin;
        this.m_error[n2] = this.m_error[n2] + v * v;
        this.m_hasWeightedEntries = true;
    }

    @Override
    public double[] getBins() {
        return this.m_hist;
    }

    @Override
    public double[] getPlusErrors() {
        double[] error = new double[this.m_bins];
        for (int i = 0; i < this.m_bins; ++i) {
            error[i] = Math.sqrt(this.m_error[i]);
        }
        return error;
    }

    @Override
    public double[] getMinusErrors() {
        return this.getPlusErrors();
    }

    @Override
    public void setNumberOfBins(int bins) {
        if (bins == this.m_bins) {
            return;
        }
        double[] hist = new double[bins];
        double[] error = new double[bins];
        System.arraycopy(this.m_hist, 0, hist, 0, Math.min(bins, this.m_bins));
        System.arraycopy(this.m_error, 0, error, 0, Math.min(bins, this.m_bins));
        this.m_hist = hist;
        this.m_error = error;
        this.m_bins = bins;
    }

    @Override
    public int getNumberOfBins() {
        return this.m_bins;
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        return !this.m_hasWeightedEntries;
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        return false;
    }
}

