/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.AbstractNamedObject;
import hepjas.analysis.Folder;
import hepjas.analysis.PageFolder;
import hepjas.analysis.Plot;
import hepjas.analysis.peer.PagePeer;
import hepjas.analysis.peer.Peer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Page
extends AbstractNamedObject {
    private transient PagePeer m_peer;
    private Vector m_plots = new Vector();
    private int m_xGrid = 0;
    private int m_yGrid = 0;
    private boolean hasConstraints;
    static final long serialVersionUID = -6203596861252571247L;

    public Page(String name) {
        this(name, PageFolder.getDefaultFolder());
    }

    public Page(String name, PageFolder parent) {
        super(name, parent);
    }

    public void add(Plot plot) {
        if (this.m_plots.isEmpty()) {
            this.hasConstraints = false;
        } else if (this.hasConstraints) {
            throw new RuntimeException("Cannot mix constrained and unconstrained plots within a page");
        }
        this.m_plots.addElement(plot);
    }

    public void add(Plot plot, double x, double y, double width, double height) {
        if (x < 0.0 || x > 100.0) {
            throw new IllegalArgumentException("x");
        }
        if (y < 0.0 || y > 100.0) {
            throw new IllegalArgumentException("y");
        }
        if (width <= 0.0 || x + width > 100.0) {
            throw new IllegalArgumentException("width");
        }
        if (height <= 0.0 || y + height > 100.0) {
            throw new IllegalArgumentException("height");
        }
        if (this.m_plots.isEmpty()) {
            this.hasConstraints = true;
        } else if (!this.hasConstraints) {
            throw new RuntimeException("Cannot mix constrained and unconstrained plots within a page");
        }
        this.m_plots.addElement(new ConstrainedPlot(plot, x, y, width, height));
    }

    public void remove(Plot plot) {
        this.m_plots.removeElement(plot);
    }

    public void removeAll() {
        this.m_plots.removeAllElements();
    }

    public void setGrid(int gridX, int gridY) {
        this.m_xGrid = gridX;
        this.m_yGrid = gridY;
    }

    public void show() {
        if (this.m_peer != null) {
            this.m_peer.show();
        }
    }

    public int getGridX() {
        return this.m_xGrid;
    }

    public int getGridY() {
        return this.m_yGrid;
    }

    public Enumeration plots() {
        return this.m_plots.elements();
    }

    public int getNPlots() {
        return this.m_plots.size();
    }

    @Override
    void setPeer(Peer peer) {
        this.m_peer = (PagePeer)peer;
    }

    @Override
    Peer getPeer() {
        return this.m_peer;
    }

    @Override
    protected Folder getDefaultParent() {
        return PageFolder.getDefaultFolder();
    }

    public String toString() {
        return "Page: " + this.getName();
    }

    public class ConstrainedPlot
    implements Serializable {
        private Plot plot;
        private double x;
        private double y;
        private double width;
        private double height;
        static final long serialVersionUID = 222934009074326407L;

        ConstrainedPlot(Plot plot, double x, double y, double width, double height) {
            this.plot = plot;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Plot getPlot() {
            return this.plot;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }
    }
}

