/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.EventAnalyzer;
import hepjas.analysis.EventSource;
import hepjas.analysis.Folder;
import hepjas.analysis.FolderSet;
import hepjas.analysis.Histogram;
import hepjas.analysis.HistogramFolder;
import hepjas.analysis.HistogramFolderSet;
import hepjas.analysis.JobError;
import hepjas.analysis.JobFolder;
import hepjas.analysis.JobOutputStream;
import hepjas.analysis.NamedObject;
import hepjas.analysis.peer.AnalysisApplication;
import hepjas.analysis.peer.JobPeer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPOutputStream;

public class Job {
    private Hashtable m_folderSets = new Hashtable();
    private Folder m_jobFolder;
    private JobPeer m_peer;
    private static AnalysisApplication theApp;
    private Histogram last;
    private HistogramFolderSet hfs;

    public Job(String name) {
        if (theApp == null) {
            String nm = System.getProperty("hep.analysis.application", "hep.analysis.standalone.StandAloneApp");
            try {
                theApp = (AnalysisApplication)Class.forName(nm).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JobError("Standalone application not found: " + nm);
            }
            catch (InstantiationException e) {
                throw new JobError("Could not instantiate standalone application: " + nm);
            }
            catch (IllegalAccessException e) {
                throw new JobError("Could not access standalone application: " + nm);
            }
        }
        this.m_peer = theApp.createJobPeer(name, this);
        this.m_jobFolder = new JobFolder(name, this);
        this.m_jobFolder.setPeer(this.m_peer);
    }

    public void setEventSource(EventSource source) {
        this.m_peer.setEventSource(source);
    }

    public void addEventAnalyzer(EventAnalyzer analyzer) {
        this.m_peer.addEventAnalyzer(analyzer);
    }

    public void removeEventAnalyzer(EventAnalyzer analyzer) {
        this.m_peer.removeEventAnalyzer(analyzer);
    }

    public void removeAllEventAnalyzers() {
        this.m_peer.removeAllEventAnalyzers();
    }

    public void go() {
        this.go(0);
    }

    public void step() {
        this.go(1);
    }

    public void go(int n) {
        this.m_peer.go(n);
    }

    public void rewind() {
        this.m_peer.rewind();
        HistogramFolderSet fs = this.histogramFolderSet(false);
        if (fs != null) {
            ((HistogramFolder)fs.getRootFolder()).rewind();
        }
    }

    public void save() {
        this.save(this.m_jobFolder.getName() + ".javahist");
    }

    public void save(String fileName) {
        this.save(new File(fileName));
    }

    public void save(File file) {
        try {
            JobOutputStream out = new JobOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            this.save(out);
            out.close();
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new RuntimeException("Error saving job" + x.getMessage());
        }
    }

    public void save(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_jobFolder);
    }

    public void dump() {
        PrintWriter out = new PrintWriter(this.m_peer.getLogStream());
        this.dump(out);
        out.flush();
    }

    public void dump(PrintWriter out) {
        Enumeration e = this.m_folderSets.elements();
        while (e.hasMoreElements()) {
            FolderSet set = (FolderSet)e.nextElement();
            set.dump(out);
        }
    }

    public static Job currentJob() {
        if (theApp == null) {
            new Job("Default Job");
        }
        return theApp.currentJob();
    }

    static void setAnalysisApplication(AnalysisApplication aa) {
        theApp = aa;
    }

    JobPeer getPeer() {
        return this.m_peer;
    }

    final Histogram findHistogram(String name) {
        return this.findHistogram(name, (HistogramFolder)this.histogramFolderSet(true).getCurrentFolder());
    }

    final Histogram findHistogram(String name, HistogramFolder folder) {
        Histogram guess;
        if (this.last != null && (guess = this.last.m_nextGuess) != null && guess.checkGuess(name, folder)) {
            this.last = guess;
            return this.last;
        }
        Histogram result = (Histogram)folder.find(name);
        if (result == null) {
            result = new Histogram(name, folder);
        }
        if (this.last != null) {
            this.last.m_nextGuess = result;
        }
        this.last = result;
        return this.last;
    }

    HistogramFolderSet histogramFolderSet(boolean create) {
        if (this.hfs == null && create) {
            this.hfs = (HistogramFolderSet)this.getFolderSet(HistogramFolderSet.class);
        }
        return this.hfs;
    }

    final void done() {
        HistogramFolderSet fs = this.histogramFolderSet(false);
        if (fs != null) {
            ((HistogramFolder)fs.getRootFolder()).done();
        }
    }

    final void resetFolders() {
        Enumeration e = this.m_folderSets.elements();
        while (e.hasMoreElements()) {
            FolderSet fs = (FolderSet)e.nextElement();
            fs.setCurrentFolder();
        }
    }

    void removeNotify(NamedObject child) {
        Enumeration e = this.m_folderSets.elements();
        while (e.hasMoreElements()) {
            FolderSet fs = (FolderSet)e.nextElement();
            if (fs.getRootFolder() != child) continue;
            this.m_folderSets.remove(fs.getClass());
            if (fs != this.hfs) break;
            this.hfs = null;
            break;
        }
    }

    FolderSet getFolderSet(Class klass) {
        FolderSet fs = (FolderSet)this.m_folderSets.get(klass);
        if (fs == null) {
            try {
                Class[] argc = new Class[]{Job.class};
                Constructor c = klass.getConstructor(argc);
                Object[] args = new Object[]{this};
                fs = (FolderSet)c.newInstance(args);
                this.m_folderSets.put(klass, fs);
            }
            catch (InvocationTargetException x) {
                throw new RuntimeException("Could not create folder set of " + klass + " :" + x.getTargetException());
            }
            catch (Exception x) {
                throw new RuntimeException("Could not create folder set of " + klass + " :" + x);
            }
        }
        return fs;
    }

    Folder getJobFolder() {
        return this.m_jobFolder;
    }
}

