/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.Folder;
import hepjas.analysis.HistogramFolder;
import hepjas.analysis.NamedObject;
import hepjas.analysis.peer.Peer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;

public abstract class AbstractNamedObject
implements NamedObject,
Serializable {
    static final long serialVersionUID = 8043079859660783625L;
    protected transient Folder m_parent;
    private String m_name;

    AbstractNamedObject(String name) {
        this.m_name = name;
        this.m_parent = null;
    }

    AbstractNamedObject(String name, Folder parent) {
        this.m_name = name;
        this.m_parent = parent;
        parent.add(this);
    }

    @Override
    public void delete() {
        if (this.m_parent != null) {
            this.m_parent.remove(this);
            this.m_parent = null;
        }
    }

    @Override
    public void rename(String newName) throws NamedObject.RenameException {
        if (this.m_parent != null) {
            if (this.m_parent.find(newName) != null) {
                throw new NamedObject.RenameException("Name already in use");
            }
            this.m_parent.remove(this);
            this.m_name = newName;
            this.m_parent.add(this);
        } else {
            this.m_name = newName;
        }
    }

    boolean checkGuess(String name, HistogramFolder folder) {
        return name == this.m_name && folder == this.m_parent;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Folder getFolder() {
        return this.m_parent;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ObjectInputValidation valid = new ObjectInputValidation(){

            @Override
            public void validateObject() {
                if (AbstractNamedObject.this.m_parent == null) {
                    AbstractNamedObject.this.m_parent = AbstractNamedObject.this.getDefaultParent();
                    if (AbstractNamedObject.this.m_parent != null) {
                        AbstractNamedObject.this.m_parent.add(AbstractNamedObject.this);
                    }
                }
            }
        };
        stream.registerValidation(valid, 0);
    }

    protected abstract Folder getDefaultParent();

    abstract void setPeer(Peer var1);

    abstract Peer getPeer();
}

