/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.RootClass;
import hep.rootio.interfaces.TDirectory;
import hep.rootio.interfaces.TKey;
import hep.rootio.util.FakeTKey;
import java.io.IOException;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootHistogramTreeModel
implements TreeModel {
    private TKey top;

    public RootHistogramTreeModel(TDirectory topDir) {
        this.top = new FakeTKey(topDir);
    }

    protected void handleException(IOException x) {
        throw new RuntimeException("IOException reading root file");
    }

    @Override
    public Object getChild(Object parent, int index) {
        try {
            TKey node = (TKey)parent;
            Object object = node.getObject();
            if (object instanceof TDirectory) {
                TDirectory dir = (TDirectory)object;
                int nKeys = dir.nKeys();
                for (int i = 0; i < nKeys; ++i) {
                    TKey key = dir.getKey(i);
                    RootClass keyClass = key.getObjectClass();
                    if (!keyClass.instanceOf("TDirectory") && !keyClass.instanceOf("TH1") || index-- != 0) continue;
                    return key;
                }
            }
            return null;
        }
        catch (IOException x) {
            this.handleException(x);
            return null;
        }
    }

    @Override
    public int getChildCount(Object parent) {
        try {
            TKey node = (TKey)parent;
            TDirectory dir = (TDirectory)node.getObject();
            int nKeys = dir.nKeys();
            int nChildren = 0;
            for (int i = 0; i < nKeys; ++i) {
                TKey key = dir.getKey(i);
                RootClass keyClass = key.getObjectClass();
                if (keyClass.instanceOf("TDirectory")) {
                    ++nChildren;
                    continue;
                }
                if (!keyClass.instanceOf("TH1")) continue;
                ++nChildren;
            }
            return nChildren;
        }
        catch (IOException x) {
            this.handleException(x);
            return 0;
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        try {
            TKey node = (TKey)parent;
            TDirectory dir = (TDirectory)node.getObject();
            int nKeys = dir.nKeys();
            int nChildren = 0;
            for (int i = 0; i < nKeys; ++i) {
                TKey key = dir.getKey(i);
                if (key == child) {
                    return nChildren;
                }
                RootClass keyClass = key.getObjectClass();
                if (keyClass.instanceOf("TDirectory")) {
                    ++nChildren;
                    continue;
                }
                if (!keyClass.instanceOf("TH1")) continue;
                ++nChildren;
            }
            return -1;
        }
        catch (IOException x) {
            this.handleException(x);
            return -1;
        }
    }

    @Override
    public Object getRoot() {
        return this.top;
    }

    @Override
    public boolean isLeaf(Object parent) {
        try {
            TKey key = (TKey)parent;
            RootClass rc = key.getObjectClass();
            return !rc.instanceOf("TDirectory");
        }
        catch (IOException x) {
            this.handleException(x);
            return true;
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treemodellistener) {
    }

    @Override
    public void valueForPathChanged(TreePath treepath, Object obj) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treemodellistener) {
    }
}

