/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.NameMangler;
import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootFileReader;
import hep.rootio.RootMember;
import hep.rootio.interfaces.TStreamerInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class InterfaceBuilder {
    private String mess = "";
    private File base;
    private NameMangler nameMangler;

    public InterfaceBuilder() {
        this.nameMangler = NameMangler.instance();
        this.base = new File(".");
    }

    public InterfaceBuilder(File dir) {
        this.nameMangler = NameMangler.instance();
        this.base = dir;
    }

    public InterfaceBuilder(String file) throws IOException {
        String tom = "";
        RootFileReader rfr = new RootFileReader(new File(file));
        RootClassFactory rcf = rfr.getFactory();
        InterfaceBuilder ib = new InterfaceBuilder(new File("."));
        List list = rfr.streamerInfo();
        for (TStreamerInfo info : list) {
            String name = info.getName();
            try {
                Class<?> k = Class.forName("hep.rootio.interfaces." + name);
                tom = tom + "Skipping " + name + "\n";
            }
            catch (ClassNotFoundException classnotfoundexception) {
                try {
                    RootClass rc = rcf.create(name);
                    File f = ib.write(rc);
                    tom = tom + "Created " + f.getPath() + "\n";
                }
                catch (RootClassNotFound e) {
                    e.printStackTrace();
                }
            }
        }
        this.mess = tom;
    }

    public String message() {
        return this.mess;
    }

    public File write(RootClass klass) throws IOException {
        String klassPath = this.nameMangler.mangleClass(klass.getClassName());
        StringBuffer packidge = new StringBuffer();
        File file = this.base;
        StringTokenizer t = new StringTokenizer(klassPath, ".");
        int count = t.countTokens() - 1;
        for (int i = 0; i < count; ++i) {
            String token = t.nextToken();
            file = new File(file, token);
            if (i > 0) {
                packidge.append('.');
            }
            packidge.append(token);
        }
        String klassName = t.nextToken();
        file.mkdirs();
        file = new File(file, klassName + ".java");
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        out.println("/*");
        out.println(" * Interface created by InterfaceBuilder. Do not modify.");
        out.println(" *");
        out.println(" * Created on " + new Date());
        out.println(" */");
        out.println();
        out.println("package " + packidge + ";");
        if (!packidge.toString().equals("hep.rootio.interfaces")) {
            out.println("import hep.rootio.interfaces.*;");
        }
        out.println();
        out.print("public interface " + klassName + " extends RootObject");
        RootClass[] superClasses = klass.getSuperClasses();
        for (int i = 0; i < superClasses.length; ++i) {
            out.print(", " + this.nameMangler.mangleClass(superClasses[i].getClassName()));
        }
        out.println();
        out.println("{");
        RootMember[] members = klass.getMembers();
        for (int i = 0; i < members.length; ++i) {
            String comment = members[i].getComment();
            if (comment != null && comment.length() > 0) {
                out.println("\t/** " + comment + " */");
            }
            RootClass type = members[i].getType();
            StringBuffer jType = new StringBuffer(type.getJavaType());
            for (int j = 0; j < members[i].getArrayDim(); ++j) {
                jType.append("[]");
            }
            String name = this.nameMangler.mangleMember(members[i].getName());
            out.println("\t" + jType + " " + name + "();");
        }
        int version = klass.getVersion();
        int checkSum = klass.getCheckSum();
        if (version > 0 || checkSum > 0) {
            out.println();
        }
        if (version > 0) {
            out.println("\tpublic final static int rootIOVersion=" + version + ";");
        }
        if (checkSum > 0) {
            out.println("\tpublic final static int rootCheckSum=" + checkSum + ";");
        }
        out.println("}");
        out.close();
        return file;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            InterfaceBuilder.usage();
        }
        RootFileReader rfr = new RootFileReader(argv[0]);
        RootClassFactory rcf = rfr.getFactory();
        InterfaceBuilder ib = new InterfaceBuilder(new File("."));
        if (argv.length > 1) {
            RootClass rc = rcf.create(argv[1]);
            File f = ib.write(rc);
            System.out.println("Created " + f.getPath());
        } else {
            List list = rfr.streamerInfo();
            for (TStreamerInfo info : list) {
                String name = info.getName();
                try {
                    Class<?> k = Class.forName("hep.rootio.interfaces." + name);
                    System.out.println("Skipping " + name);
                }
                catch (ClassNotFoundException classnotfoundexception) {
                    RootClass rc = rcf.create(name);
                    File f = ib.write(rc);
                    System.out.println("Created " + f.getPath());
                }
            }
        }
    }

    private static void usage() {
        System.out.println("java RootObjectBrowser <file> [<class>]");
        System.exit(0);
    }
}

