/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.interfaces.TBranch;
import hep.rootio.interfaces.TBranchObject;
import java.io.IOException;
import java.util.List;

class BranchEntry {
    private TBranch branch;
    private int index;
    private int offset;

    BranchEntry(Object entry, int index) {
        this(null, index, 0);
    }

    BranchEntry(TBranch branch, int index, int offset) {
        this.branch = branch;
        this.index = index;
        this.offset = offset;
    }

    int getIndex() {
        return this.index;
    }

    Object getValue() throws IOException {
        return this.branch.getEntry(this.index - this.offset);
    }

    public String toString() {
        String name;
        if (this.branch instanceof TBranchObject) {
            name = ((TBranchObject)this.branch).getClassName();
        } else {
            try {
                Object o = this.getValue();
                name = o.getClass().isArray() ? "Array" : (o instanceof List ? "List" : o.toString());
            }
            catch (IOException ioexception) {
                name = "????";
            }
        }
        return "[" + (this.index - this.offset) + "] " + name;
    }
}

