/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.AbstractRootObject;
import hep.rootio.implementation.RootByteArrayInputStream;
import hep.rootio.implementation.RootRandomAccessFile;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class RootInputStream
extends DataInputStream
implements RootInput {
    private Hashtable readMap = new Hashtable();
    private long pos = 0L;
    private RootRandomAccessFile raf;
    private static int kByteCountMask = 0x40000000;
    private static int kNewClassTag = -1;
    private static int kClassMask = Integer.MIN_VALUE;
    private static int kMapOffset = 2;

    public RootInputStream(RootByteArrayInputStream in, RootRandomAccessFile raf) {
        super(in);
        this.raf = raf;
    }

    @Override
    public String readString() throws IOException {
        return RootInputStream.readString(this);
    }

    @Override
    public String readNullTerminatedString(int maxLength) throws IOException {
        return RootInputStream.readNullTerminatedString(this, maxLength);
    }

    @Override
    public int readVersion() throws IOException {
        return RootInputStream.readVersion(this, null);
    }

    @Override
    public int readVersion(AbstractRootObject obj) throws IOException {
        return RootInputStream.readVersion(this, obj);
    }

    @Override
    public int readArray(int[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public int readArray(byte[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public int readArray(float[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public int readArray(double[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public void checkLength(AbstractRootObject obj) throws IOException {
        RootInputStream.checkLength(this, obj);
    }

    @Override
    public RootObjectRepresentation readObject(String type) throws IOException {
        return RootInputStream.readObject(this, type);
    }

    @Override
    public RootObjectRepresentation readObjectRef() throws IOException {
        return RootInputStream.readObjectRef(this, this.readMap);
    }

    @Override
    public RootClassFactory getFactory() {
        return this.raf.getFactory();
    }

    @Override
    public RootRandomAccessFile getRAF() {
        return this.raf;
    }

    @Override
    public long getPosition() {
        return ((RootByteArrayInputStream)this.in).getPosition();
    }

    public void setPosition(long pos) {
        ((RootByteArrayInputStream)this.in).setPosition(pos);
    }

    static String readString(DataInput in) throws IOException {
        int l = in.readByte();
        byte[] data = new byte[l];
        for (int i = 0; i < l; ++i) {
            data[i] = in.readByte();
        }
        return new String(data);
    }

    static String readNullTerminatedString(DataInput in, int maxLength) throws IOException {
        int actualLength = maxLength - 1;
        byte[] data = new byte[maxLength];
        for (int i = 0; i < maxLength; ++i) {
            data[i] = in.readByte();
            if (data[i] != 0) continue;
            actualLength = i;
            break;
        }
        return new String(data, 0, actualLength);
    }

    static int readVersion(RootInput in, AbstractRootObject obj) throws IOException {
        short version = in.readShort();
        if ((version & 0x4000) == 0) {
            return version;
        }
        int byteCount = ((version & 0x3FFF) << 16) + in.readUnsignedShort();
        if (obj != null) {
            obj.setExpectedLength(in.getPosition(), byteCount);
        }
        return in.readShort();
    }

    static int readArray(RootInput in, int[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readInt();
        }
        return n;
    }

    static int readArray(RootInput in, byte[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readByte();
        }
        return n;
    }

    static int readArray(RootInput in, float[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readFloat();
        }
        return n;
    }

    static int readArray(RootInput in, double[] data) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            data[i] = in.readDouble();
        }
        return n;
    }

    static void checkLength(RootInput in, AbstractRootObject obj) throws IOException {
        obj.checkLength(in.getPosition());
    }

    static RootObjectRepresentation readObject(RootInput in, String type) throws IOException {
        try {
            RootObjectRepresentation obj = in.getFactory().create(type).newInstance();
            obj.read(in);
            return obj;
        }
        catch (RootClassNotFound x) {
            throw new IOException("Could not find class " + x.getClassName());
        }
    }

    static RootObjectRepresentation readObjectRef(RootInput in, Hashtable map) throws IOException {
        int tag;
        long objStartPos = in.getPosition();
        int fVersion = 0;
        long startpos = 0L;
        int bcnt = in.readInt();
        if ((bcnt & kByteCountMask) == 0 || bcnt == kNewClassTag) {
            tag = bcnt;
            bcnt = 0;
        } else {
            fVersion = 1;
            startpos = in.getPosition();
            tag = in.readInt();
        }
        if ((tag & kClassMask) == 0) {
            if (tag == 0) {
                return null;
            }
            Object obj = map.get(new Long(tag));
            if (obj == null || !(obj instanceof RootObjectRepresentation)) {
                throw new IOException("Invalid tag found " + tag);
            }
            return (RootObjectRepresentation)obj;
        }
        if (tag == kNewClassTag) {
            try {
                String className = in.readNullTerminatedString(80);
                RootClass rootClass = in.getFactory().create(className);
                if (fVersion > 0) {
                    map.put(new Long(startpos + (long)kMapOffset), rootClass);
                } else {
                    map.put(new Long(map.size() + 1), rootClass);
                }
                RootObjectRepresentation obj = rootClass.newInstance();
                if (fVersion > 0) {
                    map.put(new Long(objStartPos + (long)kMapOffset), obj);
                } else {
                    map.put(new Long(map.size() + 1), obj);
                }
                obj.read(in);
                return obj;
            }
            catch (RootClassNotFound x) {
                throw new IOException("Class not found during object read: " + x.getClassName());
            }
        }
        Object cls = map.get(new Long(tag &= ~kClassMask));
        if (cls == null || !(cls instanceof RootClass)) {
            throw new IOException("Invalid object tag " + tag);
        }
        RootClass rootClass = (RootClass)cls;
        RootObjectRepresentation obj = rootClass.newInstance();
        if (fVersion > 0) {
            Long offset = new Long(objStartPos + (long)kMapOffset);
            map.put(offset, obj);
        } else {
            map.put(new Long(map.size() + 1), obj);
        }
        obj.read(in);
        return obj;
    }
}

