/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootFileReader;
import hep.rootio.implementation.DefaultClassFactory;
import hep.rootio.implementation.GenericRootClass;
import hep.rootio.implementation.SpecificRootClass;
import hep.rootio.implementation.StreamerInfoNew;
import hep.rootio.interfaces.TKey;
import hep.rootio.interfaces.TStreamerInfo;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class FileClassFactory
implements RootClassFactory {
    private RootClassFactory defaultClassFactory;
    private RootFileReader rfr;
    private Hashtable classMap = new Hashtable();

    public FileClassFactory(TKey streamerInfo, RootClassFactory defaultClassFactory, RootFileReader rfr) throws IOException {
        this.defaultClassFactory = defaultClassFactory;
        this.rfr = rfr;
        List tList = (List)streamerInfo.getObject();
        for (TStreamerInfo element : tList) {
            String key = element.getName();
            StreamerInfoNew info = new StreamerInfoNew(element);
            Class c = ((DefaultClassFactory)defaultClassFactory).findClass(key);
            if (c != null) {
                this.classMap.put(key, new SpecificRootClass(c, key, info, rfr));
                continue;
            }
            this.classMap.put(key, new GenericRootClass(key, info, rfr));
        }
        try {
            Enumeration e = this.classMap.elements();
            while (e.hasMoreElements()) {
                RootClass info = (RootClass)e.nextElement();
                info.resolve(this);
            }
        }
        catch (RootClassNotFound x) {
            x.printStackTrace();
            throw new RuntimeException("Could not resolve class " + x.getClassName());
        }
    }

    @Override
    public RootClass create(String name) throws RootClassNotFound {
        RootClass klass = (RootClass)this.classMap.get(name);
        if (klass != null) {
            return klass;
        }
        return this.defaultClassFactory.create(name);
    }
}

